/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import com.qarks.util.ui.swing.NoWrapTextPane;
import java.util.ArrayList;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextBlocArea
extends NoWrapTextPane {
    public static final String LINE_BREAK_ATTRIBUTE_NAME = "line_break_attribute";

    public TextBlocArea() {
        this.setBorder(null);
        Style style = this.addStyle("conflict", null);
        StyleConstants.setBackground(style, LineCellRenderer.CONFLICT_COLOR);
        style = this.addStyle("deleted", null);
        StyleConstants.setBackground(style, LineCellRenderer.DELETED_COLOR);
        style = this.addStyle("inserted", null);
        StyleConstants.setBackground(style, LineCellRenderer.INSERTED_COLOR);
        style = this.addStyle("modified", null);
        StyleConstants.setBackground(style, LineCellRenderer.MODIFIED_COLOR);
        style = this.addStyle("moved", null);
        StyleConstants.setBackground(style, LineCellRenderer.MOVED_COLOR);
        style = this.addStyle("warning", null);
        StyleConstants.setBackground(style, LineCellRenderer.WARNING_COLOR);
    }

    public void setFileLines(ArrayList<FileLine> arrayList) {
        StyledDocument styledDocument = this.getStyledDocument();
        String string = System.getProperty("line.separator");
        int n = 0;
        try {
            for (FileLine fileLine : arrayList) {
                String string2 = fileLine.getContent() + "\n";
                styledDocument.insertString(n, string2, null);
                int n2 = n + string2.length();
                switch (fileLine.getStatus()) {
                    case 6: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("conflict"), true);
                        break;
                    }
                    case 5: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("inserted"), true);
                        break;
                    }
                    case 4: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("deleted"), true);
                        break;
                    }
                    case 3: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("modified"), true);
                        break;
                    }
                    case 2: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("moved"), true);
                        break;
                    }
                    case -1: {
                        styledDocument.setCharacterAttributes(n, n2, this.getStyle("inserted"), true);
                        break;
                    }
                }
                n = n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

