## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(birdnetR)

## ----init_model---------------------------------------------------------------
# # The models are defined using the birdnet_model_* family of functions.
# # See ?birdnet_model_load for more details.
# 
# # Initialize the TensorFlow Lite model
# birdnet_model_tflite("v2.4")
# 
# # Initialize the Protobuf model
# birdnet_model_protobuf("v2.4")
# 
# 

## ----init_custom_model--------------------------------------------------------
# classifier_folder <- "/path/to/custom/model"
# classifier_name <- "Custom_Classifier"
# 
# birdnet_model_custom("v2.4", classifier_folder = classifier_folder, classifier_name = classifier_name)
# 

## ----species_in_audio---------------------------------------------------------
# library(birdnetR)
# 
# # Initialize the TFLite BirdNET Model
# model <- birdnet_model_tflite("v2.4")
# 
# # Path to an example audio file (replace with your own file path)
# audio_path <- system.file("extdata", "soundscape.mp3", package = "birdnetR")
# 
# # Predict species in the audio file
# predictions <- predict_species_from_audio_file(model, audio_path, min_confidence = 0.3, keep_empty = FALSE)
# 
# # Example output:
# #   start end      scientific_name            common_name confidence
# #       0   3 Poecile atricapillus Black-capped Chickadee  0.8140557
# #       3   6 Poecile atricapillus Black-capped Chickadee  0.3082857
# #       9  12 Haemorhous mexicanus            House Finch  0.6393781
# #      18  21  Cyanocitta cristata               Blue Jay  0.4352708
# #      18  21  Clamator coromandus Chestnut-winged Cuckoo  0.3225890
# #      21  24  Cyanocitta cristata               Blue Jay  0.3290859
# # ...
# 

## ----top_predictions----------------------------------------------------------
# # Get the top prediction for each interval
# get_top_prediction(predictions)
# 
# # Example output:
# #   start end      scientific_name            common_name confidence
# #       0   3 Poecile atricapillus Black-capped Chickadee  0.8140557
# #       3   6 Poecile atricapillus Black-capped Chickadee  0.3082857
# #       9  12 Haemorhous mexicanus            House Finch  0.6393781
# #      18  21  Cyanocitta cristata               Blue Jay  0.4352708
# #      21  24  Cyanocitta cristata               Blue Jay  0.3290859
# 
# # Note: Fewer rows appear for the interval 18-21 as only the top prediction is retained.
# 

## ----class_label_example------------------------------------------------------
# "Accipiter cooperii_Cooper's Hawk"
# "Agelaius phoeniceus_Red-winged Blackbird"

## ----label_file_paths---------------------------------------------------------
# # Retrieve the path to the full list of BirdNET classes.
# # Use this as a template for creating your custom species list, but don't modify this file directly.
# labels_path(model, language = "en_us")
# # /.../birdnet/models/v2.4/TFLite/labels/en_us.txt"
# 
# # Path to the example custom species list with a reduced number of species
# custom_species_list <- system.file("extdata", "species_list.txt", package = "birdnetR")
# read_labels(custom_species_list)
# 
# # [1] "Accipiter cooperii_Cooper's Hawk"              "Agelaius phoeniceus_Red-winged Blackbird"
# # [3] "Anas platyrhynchos_Mallard"                    "Anas rubripes_American Black Duck"
# # [5] "Ardea herodias_Great Blue Heron"               "Baeolophus bicolor_Tufted Titmouse"
# # [7] "Branta canadensis_Canada Goose"                "Bucephala albeola_Bufflehead"
# # [9] "Bucephala clangula_Common Goldeneye"           "Buteo jamaicensis_Red-tailed Hawk"
# # ...
# 

## ----use_custom_species_list--------------------------------------------------
# predict_species_from_audio_file(model, audio_path, filter_species = c("Cyanocitta cristata_Blue Jay", "Junco hyemalis_Dark-eyed Junco"), min_confidence = 0.3, keep_empty = FALSE)
# 
# # Example output:
# #   start end     scientific_name     common_name confidence
# #      18  21 Cyanocitta cristata        Blue Jay  0.4352708
# #      21  24 Cyanocitta cristata        Blue Jay  0.3290859
# #      33  36      Junco hyemalis Dark-eyed Junco  0.4590625
# #      36  39      Junco hyemalis Dark-eyed Junco  0.3536855
# #      42  45      Junco hyemalis Dark-eyed Junco  0.7375432
# 

## ----use_meta_model-----------------------------------------------------------
# # load the meta model
# meta_model <- birdnet_model_meta("v2.4")
# 
# # predict species occurrence in Ithaca, NY in week 4 of the year
# predict_species_at_location_and_time(meta_model, latitude = 42.5, longitude = -76.45, week = 4)
# 
# # Example output:
# #   label                                       confidence
# #   Cyanocitta cristata_Blue Jay                0.92886776
# #   Poecile atricapillus_Black-capped Chickadee 0.90332001
# #   Sitta carolinensis_White-breasted Nuthatch  0.83232993
# #   Cardinalis cardinalis_Northern Cardinal     0.82705086
# #   Junco hyemalis_Dark-eyed Junco              0.82440305
# #   Zenaida macroura_Mourning Dove              0.80619872
# #   Corvus brachyrhynchos_American Crow         0.80580002
# #   Dryobates pubescens_Downy Woodpecker        0.79495054
# #   Spinus tristis_American Goldfinch           0.72782934
# #   Baeolophus bicolor_Tufted Titmouse          0.63683629
# 

## ----languages----------------------------------------------------------------
# # supply the version of the BirdNET model you are using
# available_languages("v2.4")

## -----------------------------------------------------------------------------
# birdnet_model_tflite("v2.4", language = "fr")

## ----labels_language----------------------------------------------------------
# labels_path_lang <- labels_path(model, language = "fr")
# read_labels(labels_path_lang)
# 
# # Example output:
# # [1] "Abroscopus albogularis_Bouscarle à moustaches"            "Abroscopus schisticeps_Bouscarle à face noire"            "Abroscopus superciliaris_Bouscarle à sourcils blancs"
# # [4] "Aburria aburri_Pénélope aburri"                           "Acanthagenys rufogularis_Méliphage à bavette"             "Acanthidops bairdi_Bec-en-cheville gris"
# # [7] "Acanthis cabaret_Sizerin cabaret"                         "Acanthis flammea_Sizerin flammé"                          "Acanthis hornemanni_Sizerin blanchâtre"
# # [10] "Acanthisitta chloris_Xénique grimpeur"                    "Acanthiza apicalis_Acanthize troglodyte"                  "Acanthiza chrysorrhoa_Acanthize à croupion jaune"
# # [13] "Acanthiza ewingii_Acanthize de Tasmanie"                  "Acanthiza inornata_Acanthize sobre"                       "Acanthiza lineata_Acanthize ridé"

