## ----setup, include=FALSE-----------------------------------------------------
library(BioMoR)
set.seed(123)

## -----------------------------------------------------------------------------
# Prepare dataset
data(iris)
iris$Label <- ifelse(iris$Species == "setosa", "Active", "Inactive")

# Cross-validation control
ctrl <- get_cv_control(cv = 3)

# Train a Random Forest model
fit <- train_rf(iris, outcome_col = "Label", ctrl = ctrl)

# Compute simple benchmark metrics
metrics <- biomor_benchmark(fit, iris, outcome_col = "Label")
metrics

