% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall_var_independent.R
\name{kendall_var_independent}
\alias{kendall_var_independent}
\title{Asymptotic variance of estimator of Kendall's Tau between independent iid random variables}
\usage{
kendall_var_independent(n)
}
\arguments{
\item{n}{number of observations, should be integer bigger than 0.}
}
\value{
Asymptotic variance of estimator.
}
\description{
Calculates the asymptotic variance of the estimator of Kendall's Tau between iid observations
of independent random variables. The expression comes from the asymptotic normal distribution of the estimator,
see e.g. equation 2.30 in chapter 11 of Gibbons and Chakraborti (2003).
}
\examples{
kendall_var_independent(n=50)
}
\references{
J. D. Gibbons, and S. Chakraborti, Nonparametric statistical inference (4th Edition). CRC press, 2003.
}
\keyword{internal}
