/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.knowledge;

import java.io.File;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.RDFTripleStore;
import org.vikamine.kernel.knowledge.IKnowledgeParser;
import org.vikamine.kernel.util.FileUtils;

public class KnowledgeInputManager {
    public static final String COMMENT_STRING = "#";
    final Ontology ontology;
    Set<IKnowledgeParser> parsers;

    public Ontology getOntology() {
        return this.ontology;
    }

    public KnowledgeInputManager(Ontology ontology) {
        this.ontology = ontology;
        this.parsers = new HashSet<IKnowledgeParser>();
    }

    public boolean handleFile(File f) {
        String fileContent = FileUtils.readFileToString(f);
        if (fileContent == null) {
            return false;
        }
        RDFTripleStore tripleStore = this.ontology.getTripleStore();
        tripleStore.removeStatements(tripleStore.getStatementsForFile(f.getPath()));
        for (IKnowledgeParser parser : this.parsers) {
            parser.handleFile(f, new StringReader(fileContent), this.ontology);
        }
        return true;
    }

    public void addParser(IKnowledgeParser aParser) {
        this.parsers.add(aParser);
    }
}

