/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.elementBuilders;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.vikamine.kernel.formula.ParserElement;
import org.vikamine.kernel.formula.VariableParserElementBuilder;

public class DoubleElementBuilder
implements VariableParserElementBuilder {
    protected Class type = Double.class;

    @Override
    public boolean isValid(String text) {
        if (!text.matches("[\\d]+[\\,|\\.]?[\\d]*")) {
            return false;
        }
        return this.parseDouble(text) != null;
    }

    protected Double parseDouble(String text) {
        try {
            try {
                Number n = NumberFormat.getNumberInstance().parse(text);
                String localeDependentText = NumberFormat.getNumberInstance(Locale.US).format(n);
                return new Double(localeDependentText);
            }
            catch (ParseException n) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isValidStart(String substring) {
        if (!substring.endsWith(" ")) {
            return this.isValid(substring);
        }
        return false;
    }

    @Override
    public ParserElement createParserElement(String token, List beforeParserElements) {
        ParserElement pe = new ParserElement();
        pe.setType(this.getType());
        pe.setContent(this.createContent(token), token);
        return pe;
    }

    protected Object createContent(String token) {
        return this.parseDouble(token);
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

