/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.meta.DiscRanges;
import dmLab.array.saver.Array2File;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexSet;
import dmLab.classifier.adx.ruleFamily.RuleFamily;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.selector.Selector;
import dmLab.classifier.attributeIndicators.ADXSelectorIndicators;
import dmLab.discretizer.DiscretizerParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.FileUtils;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;

public final class ADXClassifier
extends Classifier {
    private ADXParams cfg;
    private FArray trainArray;
    private RuleFamily ruleFamily;
    private DiscretizerParams discParams;
    private DiscRanges[] discRangesTrain;

    public ADXClassifier() {
        this.label = labels[ADX];
        this.model = ADX;
        this.params = new ADXParams();
        this.cfg = (ADXParams)this.params;
        this.discParams = new DiscretizerParams();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final boolean train(FArray trainArray) {
        block8: {
            block10: {
                block9: {
                    if (!this.checkTargetAttr((FArray)trainArray)) {
                        return false;
                    }
                    this.trainArray = trainArray;
                    var7_2 /* !! */  = trainArray;
                    this.ruleFamily = new RuleFamily(trainArray.getDecValues().length, trainArray.attributes.length, this.cfg);
                    this.ruleFamily.verbose = this.cfg.verbose;
                    start = System.currentTimeMillis();
                    var5_5 = trainArray;
                    var4_6 = this;
                    if (var5_5.isDiscretized()) break block9;
                    System.out.println("Warning! Input table contains numeric values. Discretization is processed...");
                    var4_6.discParams.verbose = var4_6.cfg.verbose;
                    var6_8 = var4_6.discParams;
                    var5_5 = var4_6.trainArray;
                    var7_2 /* !! */  = var6_8;
                    if (var7_2 /* !! */ .discIntervals <= 0) ** GOTO lbl-1000
                    var7_2 /* !! */  = var6_8;
                    if (var7_2 /* !! */ .discAlgorithm <= 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    } else {
                        var7_2 /* !! */  = var5_5;
                        var7_3 = var5_5.attributes.length;
                        var8_11 = var5_5.getDecAttrIdx();
                        var5_5.discRanges = new DiscRanges[var5_5.attributes.length];
                        for (var9_12 = 0; var9_12 < var7_3; ++var9_12) {
                            if (var5_5.attributes[var9_12].type != 2) continue;
                            var10_13 = var5_5.getColumn(var9_12);
                            var11_14 = var5_5.getColumn(var8_11);
                            var5_5.discRanges[var9_12] = new DiscRanges();
                            if (!var5_5.discRanges[var9_12].find(var10_13, var11_14, var6_8) || !var6_8.verbose) continue;
                            System.out.println("Attribute Discretized: " + var5_5.attributes[var9_12].name + " ranges: " + Arrays.toString(var5_5.discRanges[var9_12].getRanges()));
                        }
                        v0 = true;
                    }
                    DiscFunctions.applyRanges(var4_6.trainArray);
                    break block10;
                }
                var6_9 = 0;
                while (true) {
                    var7_2 /* !! */  = var5_5;
                    if (var6_9 >= var5_5.attributes.length) break;
                    if (var5_5.attributes[var6_9].type == 2 && !var5_5.isDiscretized(var6_9)) {
                        System.err.println("Error! Input table contains numeric values that are not discretized.");
                        v1 = false;
                        break block8;
                    }
                    ++var6_9;
                }
            }
            v1 = true;
        }
        if (!v1) {
            return false;
        }
        var5_5 = trainArray.discRanges;
        var4_6 = this;
        this.discRangesTrain = (DiscRanges[])var5_5.clone();
        for (var6_10 = 0; var6_10 < var4_6.discRangesTrain.length; ++var6_10) {
            if (var4_6.trainArray.discRanges[var6_10] == null) continue;
            var4_6.discRangesTrain = (DiscRanges[])var5_5.clone();
        }
        trainArray.findADXDomains();
        this.ruleFamily.createRules((FArray)trainArray);
        stop = System.currentTimeMillis();
        this.learningTime = (float)(stop - var2_4) / 1000.0f;
        this.trainSetSize = var1_1.rowsNumber();
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_5;
        boolean bl;
        block7: {
            if (!this.checkTargetAttr(testArray)) {
                return false;
            }
            FArray fArray = testArray;
            ADXClassifier aDXClassifier = this;
            if (!fArray.isDiscretized()) {
                System.out.println("Warning! Input table contains numeric values. Discretization is applied...");
                fArray.discRanges = aDXClassifier.discRangesTrain;
                DiscFunctions.applyRanges(fArray);
            } else {
                int n = 0;
                while (true) {
                    FArray fArray2 = fArray;
                    if (n >= fArray2.attributes.length) break;
                    if (fArray.attributes[n].type == 2 && !fArray.isDiscretized(n)) {
                        System.err.println("Error! Input table contains numeric values that are not discretized.");
                        bl = false;
                        break block7;
                    }
                    ++n;
                }
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), ((Array)testArray).getDecValuesStr());
        int testEventsNumber = ((Array)testArray).rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        this.ruleFamily.prepareClassification();
        for (int i = 0; i < testEventsNumber; ++i) {
            float predictedDecision = this.ruleFamily.classifyEvent2(testArray, i);
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, predictedClassName, this.ruleFamily.getLastScores());
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_5) / 1000.0f;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(" ### ADX Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.ruleFamily.toString()).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) {
        void var2_2;
        void var1_1;
        block7: {
            FArray fArray;
            Array2File array2File = new Array2File();
            array2File.setFormat(0);
            ((Array2File)((Object)fArray)).saveFile(this.trainArray, path + "//" + name);
            String string = path + "//" + name;
            fArray = this.trainArray;
            Object object = FileUtils.getFileExtension(string);
            if (!((String)object).equalsIgnoreCase("dsc")) {
                string = string + ".dsc";
            }
            try {
                object = new FileWriter(string, false);
            }
            catch (IOException iOException) {
                System.err.println("Error opening file. File: " + string);
                break block7;
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                FArray fArray2 = fArray;
                int n = fArray2.attributes.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("Attribute: " + i).append(" # ").append(fArray.attributes[i].name).append('\n');
                    boolean bl = false;
                    if (fArray.isDiscretized(i)) {
                        bl = true;
                    }
                    stringBuffer.append("Discretized: " + bl).append('\n');
                    if (!bl) continue;
                    stringBuffer.append("Ranges: " + fArray.discRanges[i].getSize()).append('\n');
                    stringBuffer.append(fArray.discRanges[i].toString());
                    stringBuffer.append('\n');
                }
                ((Writer)object).write(stringBuffer.toString());
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Error writing file. File: " + string);
                iOException.printStackTrace();
            }
        }
        this.params.save(path, name);
        this.ruleFamily.saveSymbolicSelectors(path + "//" + name);
        this.ruleFamily.saveSelectors(path + "//" + name);
        this.ruleFamily.saveRuleFamily((String)var1_1 + "//" + (String)var2_2);
        return false;
    }

    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        this.attrSet = new HashSet();
        ADXSelectorIndicators selectorIndicators = new ADXSelectorIndicators();
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = QualityMeasure.calcWAcc(this.predResult.confusionMatrix.getMatrix());
        int rulesets = this.ruleFamily.ruleSets();
        for (int f = 0; f < rulesets; ++f) {
            RuleSet ruleset = this.ruleFamily.getRuleSet(f);
            for (int r = 0; r < ruleset.complexSetArray.length; ++r) {
                ComplexSet complexList = ruleset.complexSetArray[r];
                if (complexList == null) continue;
                int complexesListSize = complexList.size();
                for (int c = 0; c < complexesListSize; ++c) {
                    Complex complex;
                    Cloneable cloneable = complex = complexList.getComplex(c);
                    ADXSelectorIndicators aDXSelectorIndicators = selectorIndicators;
                    selectorIndicators.complexPosCoverage = cloneable.posCoverage;
                    aDXSelectorIndicators.complexNegCoverage = cloneable.negCoverage;
                    aDXSelectorIndicators.complexCoverage = cloneable.coverage;
                    int complexSize = complex.size();
                    for (int s = 0; s < complexSize; ++s) {
                        Selector selector = this.ruleFamily.selectorListArray[f].getSelector(complex.getSelectorId(s));
                        cloneable = selector;
                        aDXSelectorIndicators = selectorIndicators;
                        selectorIndicators.posCoverage = ((Selector)cloneable).posCoverage;
                        aDXSelectorIndicators.negCoverage = ((Selector)cloneable).negCoverage;
                        aDXSelectorIndicators.coverage = ((Selector)cloneable).coverage;
                        String attrName = this.trainArray.attributes[selector.attrIndex].name;
                        importances[0].addImportances(attrName, experimentIndicators, selectorIndicators);
                        importances[f + 1].addImportances(attrName, experimentIndicators, selectorIndicators);
                        this.attrSet.add(attrName);
                    }
                }
            }
        }
        for (int i = 0; i < importances.length; ++i) {
            importances[i].flushMeasures();
        }
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }
}

