/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.symmbreaking;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropSymmetryBreaking
extends Propagator<BoolVar> {
    private final int n;
    private final BoolVar[] t;

    public PropSymmetryBreaking(BoolVar[] t) {
        super((Variable[])t, (Priority)PropagatorPriority.QUADRATIC, false);
        this.n = (int)Math.round(Math.sqrt(t.length));
        this.t = t;
    }

    private Cmp compare(BoolVar a2, BoolVar b) {
        if (a2.isInstantiatedTo(0) && b.isInstantiatedTo(1)) {
            return Cmp.LESS;
        }
        if (a2.isInstantiatedTo(0) && b.isInstantiatedTo(0) || a2.isInstantiatedTo(1) && b.isInstantiatedTo(1)) {
            return Cmp.EQUALS;
        }
        if (a2.isInstantiatedTo(1) && b.isInstantiatedTo(0)) {
            return Cmp.GREATER;
        }
        return Cmp.UNDEFINED;
    }

    private boolean lessOrEquals(int j1, int j2) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            Cmp cmp;
            if (this.t[i + j1 * this.n].isInstantiatedTo(1)) {
                this.t[i + j2 * this.n].instantiateTo(1, (ICause)this);
            }
            if ((cmp = this.compare(this.t[i + j1 * this.n], this.t[i + j2 * this.n])) == Cmp.LESS || cmp == Cmp.UNDEFINED) {
                return true;
            }
            if (cmp != Cmp.GREATER) continue;
            return false;
        }
        return true;
    }

    private boolean sorted() throws ContradictionException {
        for (int j = 0; j < this.n - 1; ++j) {
            if (this.lessOrEquals(j, j + 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (!this.sorted()) {
            throw new ContradictionException();
        }
    }

    @Override
    public ESat isEntailed() {
        try {
            if (!this.sorted()) {
                return ESat.FALSE;
            }
        }
        catch (ContradictionException e) {
            return ESat.FALSE;
        }
        for (BoolVar aT : this.t) {
            if (aT.isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private static enum Cmp {
        LESS,
        EQUALS,
        GREATER,
        UNDEFINED;

    }
}

