/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.logical;

import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.logical.LoExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class BiLoExpression
extends LoExpression {
    private final ReExpression e1;
    private final ReExpression e2;

    public BiLoExpression(LoExpression.Operator op, ReExpression e1, ReExpression e2) {
        super(e1.getModel(), op);
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            BoolVar b1 = this.e1.boolVar();
            BoolVar b2 = this.e2.boolVar();
            this.me = this.model.boolVar(this.model.generateName((Object)((Object)this.op) + "_exp_"));
            switch (this.op) {
                case XOR: {
                    this.model.addClausesBoolXorEqVar(b1, b2, this.me);
                    break;
                }
                case IFF: {
                    this.model.addClausesBoolIsEqVar(b1, b2, this.me);
                    break;
                }
                case IMP: {
                    this.model.addClausesBoolOrEqVar(b1.not(), b2, this.me);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary logical expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        this.e1.extractVar(variables);
        this.e2.extractVar(variables);
    }

    @Override
    public Constraint decompose() {
        BoolVar v1 = this.e1.boolVar();
        BoolVar v2 = this.e2.boolVar();
        Model model = v1.getModel();
        switch (this.op) {
            case XOR: {
                return model.arithm((IntVar)v1, "!=", v2);
            }
            case IFF: {
                return model.arithm((IntVar)v1, "=", v2);
            }
            case IMP: {
                return model.arithm((IntVar)v1.not(), "+", (IntVar)v2, ">", 0);
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e1.beval(values, map), this.e2.beval(values, map));
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + ", " + this.e2.toString() + ")";
    }
}

