/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.chocosolver.sat.MiniSat;

public interface Dimacs {
    public static final String TAG_COMM = "c";
    public static final String TAG_PROB = "p";
    public static final String TAG_CNF = "cnf";

    public MiniSat _me();

    default public void parse(String pathToFile) throws FileNotFoundException {
        FileReader reader = new FileReader(pathToFile);
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            int nclauses = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(TAG_COMM) || !line.startsWith(TAG_PROB)) continue;
                String[] values = (String[])Arrays.stream(line.split("\\s+")).filter(v -> !v.isEmpty()).toArray(String[]::new);
                if (!values[1].equals(TAG_CNF)) {
                    throw new IllegalStateException("Not a CNF file");
                }
                int nvars = Integer.parseInt(values[2]);
                nclauses = Integer.parseInt(values[3]);
                break;
            }
            TIntArrayList lits = new TIntArrayList();
            while ((line = br.readLine()) != null) {
                if (line.startsWith(TAG_COMM)) continue;
                int[] ls = Arrays.stream(line.split("\\s+")).filter(v -> !v.isEmpty()).mapToInt(Integer::parseInt).toArray();
                int i = 0;
                for (int j = 0; j < ls.length && (i = ls[j]) != 0; ++j) {
                    int var = Math.abs(i) - 1;
                    while (var >= this._me().nVars()) {
                        this._me().newVariable();
                    }
                    lits.add(i > 0 ? MiniSat.makeLiteral(var) : MiniSat.neg(MiniSat.makeLiteral(var)));
                }
                if (i != 0 || lits.isEmpty()) continue;
                --nclauses;
                this._me().addClause(lits);
                lits.clear();
            }
            if (nclauses != 0) {
                throw new IllegalStateException("Missing clauses");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

