## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(renz)

## -----------------------------------------------------------------------------
d <- sE.progress(So = 1, time = 60, Km = 2, Vm = 0.1, plot = FALSE)

## -----------------------------------------------------------------------------
plot(d$t, d$St, ty = 'l', xlab = "Time (min)", ylab = "[S] (mM)")
points(d$t[which(d$t == 30)], d$St[which(d$t == 30)], pch = 19, col = "red")
text(30, 0.5, paste("(30, ", round(d$St[which(d$t == 30)], 2), ")", sep = ""), col = "red")

## -----------------------------------------------------------------------------
x <- 0
for(i in 1:5){
  x <- x - (x*exp(x) -1)/(exp(x)*(1 + x))
  print(paste("iteration ", i, ":    x = ", x, ", y = ", x*exp(x), sep = ""))
}

## ----echo=FALSE---------------------------------------------------------------
library(knitr)
data <- data.frame(t = d$t[seq(1,100,5)], S = d$S_mean[seq(1,100,5)])
kable(data)

## -----------------------------------------------------------------------------
fE.progress(data)

