/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.index;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CASNumber {
    public static boolean isValid(String casNumber) {
        boolean overall = true;
        String format = "^(\\d+)-(\\d\\d)-(\\d)$";
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(casNumber);
        boolean bl = overall = overall && matcher.matches();
        if (matcher.matches()) {
            String part1 = matcher.group(1);
            String part2 = matcher.group(2);
            String part3 = matcher.group(3);
            int digit = CASNumber.calculateCheckDigit(part1, part2);
            overall = overall && digit == Integer.parseInt(part3);
        }
        return overall;
    }

    private static int calculateCheckDigit(String part1, String part2) {
        int total = 0;
        total += 1 * Integer.parseInt(part2.substring(1, 2));
        total += 2 * Integer.parseInt(part2.substring(0, 1));
        int length = part1.length();
        for (int i = 0; i < length; ++i) {
            total += (3 + i) * Integer.parseInt(part1.substring(length - 1 - i, length - i));
        }
        return total % 10;
    }
}

