/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import java.util.Iterator;
import opennlp.model.Event;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDEventStream
extends AbstractEventStream<SentenceSample> {
    private SDContextGenerator cg;
    private EndOfSentenceScanner scanner;

    public SDEventStream(ObjectStream<SentenceSample> samples, SDContextGenerator cg, EndOfSentenceScanner scanner) {
        super(samples);
        this.cg = cg;
        this.scanner = scanner;
    }

    @Override
    protected Iterator<Event> createEvents(SentenceSample sample) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Span sentenceSpan : sample.getSentences()) {
            String sentenceString = ((Object)sentenceSpan.getCoveredText(sample.getDocument())).toString();
            Iterator<Integer> it = this.scanner.getPositions(sentenceString).iterator();
            while (it.hasNext()) {
                int candidate = it.next();
                String type = "n";
                if (!it.hasNext()) {
                    type = "s";
                }
                events.add(new Event(type, this.cg.getContext(sample.getDocument(), sentenceSpan.getStart() + candidate)));
            }
        }
        return events.iterator();
    }
}

