/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import opennlp.tools.formats.muc.MucElementNames;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.formats.muc.SgmlParser;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MucCorefContentHandler
extends SgmlParser.ContentHandler {
    static final String COREF_ELEMENT = "COREF";
    private final Tokenizer tokenizer;
    private final List<RawCorefSample> samples;
    boolean isInsideContentElement = false;
    private final List<String> text = new ArrayList<String>();
    private Stack<CorefMention> mentionStack = new Stack();
    private List<CorefMention> mentions = new ArrayList<CorefMention>();
    private Map<Integer, Integer> idMap = new HashMap<Integer, Integer>();
    private RawCorefSample sample;

    MucCorefContentHandler(Tokenizer tokenizer, List<RawCorefSample> samples) {
        this.tokenizer = tokenizer;
        this.samples = samples;
    }

    private int resolveId(int id) {
        Integer refId = this.idMap.get(id);
        if (refId != null) {
            if (id == refId) {
                return id;
            }
            return this.resolveId(refId);
        }
        return -1;
    }

    @Override
    public void startElement(String name, Map<String, String> attributes) {
        if ("DOC".equals(name)) {
            this.idMap.clear();
            this.sample = new RawCorefSample(new ArrayList<String>(), new ArrayList<CorefMention[]>());
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(name)) {
            this.isInsideContentElement = true;
        }
        if (COREF_ELEMENT.equals(name)) {
            int id;
            int beginOffset = this.text.size();
            String idString = attributes.get("ID");
            String refString = attributes.get("REF");
            if (idString != null) {
                id = Integer.parseInt(idString);
                if (refString == null) {
                    this.idMap.put(id, id);
                } else {
                    int ref = Integer.parseInt(refString);
                    this.idMap.put(id, ref);
                }
            } else {
                id = -1;
            }
            this.mentionStack.push(new CorefMention(new Span(beginOffset, beginOffset), id, attributes.get("MIN")));
        }
    }

    @Override
    public void characters(CharSequence chars) {
        if (this.isInsideContentElement) {
            String[] tokens = this.tokenizer.tokenize(((Object)chars).toString());
            this.text.addAll(Arrays.asList(tokens));
        }
    }

    @Override
    public void endElement(String name) {
        if (COREF_ELEMENT.equals(name)) {
            CorefMention mention = this.mentionStack.pop();
            mention.span = new Span(mention.span.getStart(), this.text.size());
            this.mentions.add(mention);
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(name)) {
            this.sample.getTexts().add(this.text.toArray(new String[this.text.size()]));
            this.sample.getMentions().add(this.mentions.toArray(new CorefMention[this.mentions.size()]));
            this.mentions.clear();
            this.text.clear();
            this.isInsideContentElement = false;
        }
        if ("DOC".equals(name)) {
            for (CorefMention[] mentions : this.sample.getMentions()) {
                for (int i = 0; i < mentions.length; ++i) {
                    mentions[i].id = this.resolveId(mentions[i].id);
                }
            }
            this.samples.add(this.sample);
        }
    }

    static class CorefMention {
        Span span;
        int id;
        String min;

        CorefMention(Span span, int id, String min) {
            this.span = span;
            this.id = id;
            this.min = min;
        }
    }
}

