/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.ext.ExtensionLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerFactory
extends BaseToolFactory {
    public static ChunkerFactory create(String subclassName) throws InvalidFormatException {
        if (subclassName == null) {
            return new ChunkerFactory();
        }
        try {
            ChunkerFactory theFactory = ExtensionLoader.instantiateExtension(ChunkerFactory.class, subclassName);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DefaultChunkerSequenceValidator();
    }

    public ChunkerContextGenerator getContextGenerator() {
        return new DefaultChunkerContextGenerator();
    }
}

