/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class Lex
extends AbstractLargeIntSConstraint {
    public int n;
    public IStateInt alpha;
    public IStateInt beta;
    public IStateBool entailed;
    public IntDomainVar[] x;
    public IntDomainVar[] y;
    public boolean strict = false;

    public Lex(IntDomainVar[] vars, int n, boolean strict, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, vars);
        this.x = new IntDomainVar[n];
        this.y = new IntDomainVar[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = vars[i];
            this.y[i] = vars[i + n];
        }
        this.strict = strict;
        this.n = n;
        this.alpha = environment.makeInt(0);
        this.beta = environment.makeInt(0);
        this.entailed = environment.makeBool(false);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return 4;
        }
        return 11;
    }

    public boolean groundEq(IntDomainVar x1, IntDomainVar y1) {
        if (x1.isInstantiated() && y1.isInstantiated()) {
            return x1.getVal() == y1.getVal();
        }
        return false;
    }

    public boolean leq(IntDomainVar x1, IntDomainVar y1) {
        return x1.getSup() <= y1.getInf();
    }

    public boolean less(IntDomainVar x1, IntDomainVar y1) {
        return x1.getSup() < y1.getInf();
    }

    public boolean greater(IntDomainVar x1, IntDomainVar y1) {
        return x1.getInf() > y1.getSup();
    }

    public boolean checkLex(int i) {
        if (!this.strict) {
            if (i == this.n - 1) {
                return this.leq(this.x[i], this.y[i]);
            }
            return this.less(this.x[i], this.y[i]);
        }
        return this.less(this.x[i], this.y[i]);
    }

    public void ACleq(int i) throws ContradictionException {
        this.x[i].updateSup(this.y[i].getSup(), this, false);
        this.y[i].updateInf(this.x[i].getInf(), this, false);
    }

    public void ACless(int i) throws ContradictionException {
        this.x[i].updateSup(this.y[i].getSup() - 1, this, false);
        this.y[i].updateInf(this.x[i].getInf() + 1, this, false);
    }

    public void updateAlpha(int i) throws ContradictionException {
        if (i == this.beta.get()) {
            this.fail();
        }
        if (i == this.n) {
            this.entailed.set(true);
        } else if (!this.groundEq(this.x[i], this.y[i])) {
            this.alpha.set(i);
            this.filter(i);
        } else {
            this.updateAlpha(i + 1);
        }
    }

    public void updateBeta(int i) throws ContradictionException {
        if (i + 1 == this.alpha.get()) {
            this.fail();
        }
        if (this.x[i].getInf() < this.y[i].getSup()) {
            this.beta.set(i + 1);
            if (this.x[i].getSup() >= this.y[i].getInf()) {
                this.filter(i);
            }
        } else if (this.x[i].getInf() == this.y[i].getSup()) {
            this.updateBeta(i - 1);
        }
    }

    public void initialize() throws ContradictionException {
        int i;
        this.entailed.set(false);
        for (i = 0; i < this.n && this.groundEq(this.x[i], this.y[i]); ++i) {
        }
        if (i == this.n) {
            if (!this.strict) {
                this.entailed.set(true);
            } else {
                this.fail();
            }
        } else {
            this.alpha.set(i);
            if (this.checkLex(i)) {
                this.entailed.set(true);
            }
            this.beta.set(-1);
            while (i != this.n && this.x[i].getInf() <= this.y[i].getSup()) {
                if (this.x[i].getInf() == this.y[i].getSup()) {
                    if (this.beta.get() == -1) {
                        this.beta.set(i);
                    }
                } else {
                    this.beta.set(-1);
                }
                ++i;
            }
            if (i == this.n) {
                if (!this.strict) {
                    this.beta.set(Integer.MAX_VALUE);
                } else {
                    this.beta.set(this.n);
                }
            } else if (this.beta.get() == -1) {
                this.beta.set(i);
            }
            if (this.alpha.get() >= this.beta.get()) {
                this.fail();
            }
            this.filter(this.alpha.get());
        }
    }

    public void filter(int i) throws ContradictionException {
        if (i < this.beta.get() && !this.entailed.get()) {
            if (i == this.alpha.get() && i + 1 == this.beta.get()) {
                this.ACless(i);
                if (this.checkLex(i)) {
                    this.entailed.set(true);
                }
            } else if (i == this.alpha.get() && i + 1 < this.beta.get()) {
                this.ACleq(i);
                if (this.checkLex(i)) {
                    this.entailed.set(true);
                } else if (this.groundEq(this.x[i], this.y[i])) {
                    this.updateAlpha(i + 1);
                }
            } else if (this.alpha.get() < i && i < this.beta.get() && (i == this.beta.get() - 1 && this.x[i].getInf() == this.y[i].getSup() || this.greater(this.x[i], this.y[i]))) {
                this.updateBeta(i - 1);
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.n) {
            this.filter(idx);
        } else {
            this.filter(idx - this.n);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx < this.n) {
            this.filter(idx);
        } else {
            this.filter(idx - this.n);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx < this.n) {
            this.filter(idx);
        } else {
            this.filter(idx - this.n);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.n) {
            this.filter(idx);
        } else {
            this.filter(idx - this.n);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(this.alpha.get());
    }

    @Override
    public void awake() throws ContradictionException {
        this.initialize();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.x.length; ++i) {
            int xi = tuple[i];
            int yi = tuple[i + this.n];
            if (xi < yi) {
                return true;
            }
            if (xi <= yi) continue;
            return false;
        }
        if (this.strict) {
            return false;
        }
        return tuple[this.n - 1] == tuple[this.n - 1 + this.n];
    }

    @Override
    public String pretty() {
        IntDomainVar var;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (i = 0; i < this.x.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.x[i];
            sb.append(var.pretty());
        }
        sb.append("} <");
        if (!this.strict) {
            sb.append("=");
        }
        sb.append("_lex {");
        for (i = 0; i < this.y.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.y[i];
            sb.append(var.pretty());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on choco.cp.cpsolver.constraints.global.Lex");
    }
}

