/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree.mut;

import java.util.ArrayList;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.Population;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeIndividual;
import net.sourceforge.jclec.exprtree.ExprTreeIndividualSpecies;
import net.sourceforge.jclec.exprtree.ExprTreeMutator;
import net.sourceforge.jclec.exprtree.ExprTreeMutatorTest;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.exprtree.fun.Add;
import net.sourceforge.jclec.exprtree.fun.Mul;
import net.sourceforge.jclec.exprtree.fun.Sub;
import net.sourceforge.jclec.exprtree.fun.X;
import net.sourceforge.jclec.exprtree.fun.Y;
import net.sourceforge.jclec.exprtree.fun.Z;
import net.sourceforge.jclec.exprtree.mut.PromoteMutator;
import net.sourceforge.jclec.util.random.DummyRandGenFactory;

public class PromoteMutatorTest
extends ExprTreeMutatorTest {
    public PromoteMutatorTest(String name) {
        super(name);
    }

    @Override
    protected void initTool() {
        ((ExprTreeMutator)this.tool).setBaseOp(new PromoteMutator());
    }

    @Override
    protected void createExpected() {
        this.expected = new ArrayList();
        ExprTree genotype = new ExprTree();
        genotype.addBlock(new Add());
        genotype.addBlock(new X());
        genotype.addBlock(new Sub());
        genotype.addBlock(new Mul());
        genotype.addBlock(new Sub());
        genotype.addBlock(new Add());
        genotype.addBlock(new X());
        genotype.addBlock(new Y());
        genotype.addBlock(new Z());
        genotype.addBlock(new Y());
        genotype.addBlock(new Z());
        this.expected.add(new ExprTreeIndividual(genotype));
    }

    @Override
    protected void createParents() {
        this.parents = new ArrayList();
        ExprTree genotype = new ExprTree();
        genotype.addBlock(new Add());
        genotype.addBlock(new X());
        genotype.addBlock(new Sub());
        genotype.addBlock(new Mul());
        genotype.addBlock(new Add());
        genotype.addBlock(new X());
        genotype.addBlock(new Y());
        genotype.addBlock(new Y());
        genotype.addBlock(new Z());
        this.parents.add(new ExprTreeIndividual(genotype));
    }

    @Override
    protected ISystem createContext() {
        Population pop = new Population();
        DummyRandGenFactory randGenFactory = new DummyRandGenFactory();
        randGenFactory.setDummySequence(new double[]{0.1, 0.2, 0.4, 0.5, 0.7, 0.9});
        pop.setRandGenFactory(randGenFactory);
        ExprTreeIndividualSpecies species = new ExprTreeIndividualSpecies();
        species.setMinTreeSize(1);
        species.setMaxTreeSize(15);
        species.setRootType(Double.class);
        species.setTerminals(new IPrimitive[]{new X(), new Y(), new Z()});
        species.setFunctions(new IPrimitive[]{new Add(), new Sub(), new Mul()});
        pop.setSpecies(species);
        return pop;
    }
}

