/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.myDataset;
import org.core.Randomize;

public class GARProcess {
    private myDataset ds;
    private boolean[] marked;
    private double[] allow_ampl;
    ArrayList<Chromosome> freqIts;
    ArrayList<AssociationRule> assoc_rules;
    private int nItemset;
    private int nTrials;
    private int trials;
    private int popsize;
    private double ps;
    private double pc;
    private double pm;
    private double w;
    private double y;
    private double u;
    private int limit;
    private double avg_ampl;

    public GARProcess(myDataset ds, int nItemset, int nTrials, int popsize, double ps, double pc, double pm, double w, double y, double u, double AF) {
        this.ds = ds;
        this.marked = new boolean[this.ds.getnTrans()];
        this.nItemset = nItemset;
        this.nTrials = nTrials;
        this.popsize = popsize;
        this.ps = ps;
        this.pc = pc;
        this.pm = pm;
        this.w = w;
        this.y = y;
        this.u = u;
        this.limit = (int)Math.ceil((double)popsize * ps);
        this.allow_ampl = new double[this.ds.getnVars()];
        for (int i = 0; i < this.allow_ampl.length; ++i) {
            this.allow_ampl[i] = (this.ds.getMax(i) - this.ds.getMin(i)) / AF;
        }
    }

    public void run() {
        int nTrans = this.ds.getnTrans();
        this.avg_ampl = 0.0;
        this.freqIts = new ArrayList();
        for (int i = 0; i < nTrans; ++i) {
            this.marked[i] = false;
        }
        while (this.freqIts.size() < this.nItemset) {
            System.out.println("Number of Itemsets Selected: " + this.freqIts.size());
            int nGn = 0;
            this.trials = 0;
            ArrayList<Chromosome> popCurrent = this.initialize();
            while (this.trials < this.nTrials) {
                System.out.println("Generation: " + nGn);
                ArrayList<Chromosome> popNew = this.select(popCurrent);
                this.crossover(popNew);
                this.mutate(popNew);
                popCurrent = popNew;
                ++nGn;
            }
            Collections.sort(popCurrent);
            Chromosome chromoBest = popCurrent.get(0);
            this.penalizeRecordsCoveredBy(chromoBest);
            this.freqIts.add(chromoBest.copy());
            this.avg_ampl += this.avgAmplitudeBestChromosome(chromoBest);
        }
        this.genRules();
    }

    public void printReport(double minConfidence, double minSupport) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLength();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        System.out.println("Number of Frequent Itemsets generated: " + this.freqIts.size());
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            System.out.println("Average SupportRules: " + GARProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average Confidence: " + GARProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Lift: " + GARProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Conviction: " + GARProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + GARProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Netconf: " + GARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average YulesQ: " + GARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + GARProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minConfidence, minSupport) / (double)this.ds.getnTrans());
        } else {
            System.out.println("Average Support: 0.0");
            System.out.println("Average Confidence: 0.0");
            System.out.println("Average Lift: 0.0");
            System.out.println("Average Conviction: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            System.out.println("Average Netconf: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public String printRules(ArrayList<AssociationRule> rules) {
        boolean stop = false;
        String rulesList = "";
        rulesList = rulesList + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < rules.size() && !stop; ++i) {
            int lenghtrule = rules.get(i).getAntecedent().size() + rules.get(i).getConsequent().size();
            rulesList = rulesList + "" + GARProcess.roundDouble(rules.get(i).getAll_support(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getSupport_Ant(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getSupport_cons(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getConfidence(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getLift(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getConv(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getCF(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getNetConf(), 2) + "\t" + GARProcess.roundDouble(rules.get(i).getYulesQ(), 2) + "\t" + lenghtrule + "\n";
        }
        return rulesList;
    }

    public void saveReport(double minConfidence, double minSupport, PrintWriter w) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLength();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        w.println("\nNumber of Frequent Itemsets generated: " + this.freqIts.size());
        System.out.println("Number of Frequent Itemsets generated: " + this.freqIts.size());
        w.println("\nNumber of Association Rules generated: " + countRules);
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            w.println("Average Support: " + GARProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average SupportRules: " + GARProcess.roundDouble(avg_sup / (double)countRules, 2));
            w.println("Average Confidence: " + GARProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Confidence: " + GARProcess.roundDouble(avg_conf / (double)countRules, 2));
            w.println("Average Lift: " + GARProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Lift: " + GARProcess.roundDouble(avg_lift / (double)countRules, 2));
            w.println("Average Conviction: " + GARProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Conviction: " + GARProcess.roundDouble(avg_conv / (double)countRules, 2));
            w.println("Average Certain Factor: " + GARProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + GARProcess.roundDouble(avg_CF / (double)countRules, 2));
            w.println("Average Netconf: " + GARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average Netconf: " + GARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            w.println("Average YulesQ: " + GARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average YulesQ: " + GARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            w.println("Average Antecedents Length: " + GARProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + GARProcess.roundDouble((double)length / (double)countRules, 2));
            w.println("Number of Covered Records (%): " + GARProcess.roundDouble(100.0 * (double)this.numCoveredRecords(minConfidence, minSupport) / (double)this.ds.getnTrans(), 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minConfidence, minSupport) / (double)this.ds.getnTrans());
        } else {
            w.println("Average Support: 0.0");
            System.out.println("Average Support: 0.0");
            w.println("Average Confidence: 0.0");
            System.out.println("Average Confidence: 0.0");
            w.println("Average Lift: 0.0");
            System.out.println("Average Lift: 0.0");
            w.println("Average Conviction: 0.0");
            System.out.println("Average Conviction: 0.0");
            w.println("Average Certain Factor: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            w.println("Average Netconf: 0.0");
            System.out.println("Average Netconf: 0.0");
            w.println("Average Antecedents Length: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            w.println("Number of Covered Records (%): 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public ArrayList<AssociationRule> getSetRules(double minConfidence, double minSupport) {
        ArrayList<AssociationRule> selectRules = new ArrayList<AssociationRule>();
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            selectRules.add(rule.copy());
        }
        return selectRules;
    }

    private ArrayList<Chromosome> initialize() {
        ArrayList<Chromosome> popInit = new ArrayList<Chromosome>();
        int nVars = this.ds.getnVars();
        boolean[] sel_attr = new boolean[nVars];
        while (popInit.size() < this.popsize) {
            for (int i = 0; i < nVars; ++i) {
                sel_attr[i] = false;
            }
            int n_genes = Randomize.RandintClosed(2, nVars);
            Gene[] genes = new Gene[n_genes];
            for (int g = 0; g < n_genes; ++g) {
                double ub;
                double lb;
                genes[g] = new Gene();
                int attr = Randomize.Randint(0, nVars);
                while (sel_attr[attr]) {
                    attr = (attr + 1) % nVars;
                }
                sel_attr[attr] = true;
                genes[g].setAttr(attr);
                genes[g].setType(this.ds.getAttributeType(attr));
                double max_attr = this.ds.getMax(attr);
                double min_attr = this.ds.getMin(attr);
                if (genes[g].getType() != 0) {
                    double top;
                    if (genes[g].getType() == 2) {
                        lb = Randomize.RanddoubleClosed(min_attr, max_attr);
                        top = Math.min(lb + this.allow_ampl[attr], max_attr);
                        ub = Randomize.RanddoubleClosed(lb + 1.0E-4, top);
                    } else {
                        lb = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                        top = Math.min(lb + this.allow_ampl[attr], max_attr);
                        ub = Randomize.RandintClosed((int)lb + 1, (int)top);
                    }
                } else {
                    lb = ub = (double)Randomize.RandintClosed((int)min_attr, (int)max_attr);
                }
                genes[g].setL(lb);
                genes[g].setU(ub);
            }
            Chromosome c = new Chromosome(genes);
            this.fitness(c);
            if (!(c.getFit() > -5.0)) continue;
            popInit.add(c);
        }
        return popInit;
    }

    private ArrayList<Chromosome> select(ArrayList<Chromosome> pop) {
        ArrayList<Chromosome> popTmp = new ArrayList<Chromosome>();
        Collections.sort(pop);
        for (int i = 0; i <= this.limit; ++i) {
            popTmp.add(pop.get(i).copy());
        }
        return popTmp;
    }

    private void crossover(ArrayList<Chromosome> pop) {
        while (pop.size() < this.popsize) {
            Chromosome off_best;
            Gene gen2;
            Gene gen1;
            Chromosome p1 = pop.get(Randomize.Randint(0, pop.size()));
            Chromosome p2 = pop.get(Randomize.Randint(0, pop.size()));
            if (!(Randomize.Rand() < this.pc)) continue;
            int posP2 = 0;
            int posP1 = 0;
            int posOff2 = 0;
            int posOff1 = 0;
            Gene[] genesOff1 = new Gene[this.ds.getnVars()];
            Gene[] genesOff2 = new Gene[this.ds.getnVars()];
            while (posP1 < p1.length() && posP2 < p2.length()) {
                gen1 = p1.getGen(posP1);
                gen2 = p2.getGen(posP2);
                if (gen1.getAttr() == gen2.getAttr()) {
                    genesOff1[posOff1] = Randomize.Rand() < 0.5 ? gen1.copy() : gen2.copy();
                    genesOff2[posOff2] = Randomize.Rand() < 0.5 ? gen1.copy() : gen2.copy();
                    ++posOff1;
                    ++posOff2;
                    ++posP1;
                    ++posP2;
                    continue;
                }
                if (gen1.getAttr() < gen2.getAttr()) {
                    if (Randomize.Rand() < 0.5) {
                        genesOff1[posOff1] = gen1.copy();
                        ++posOff1;
                    } else {
                        genesOff2[posOff2] = gen1.copy();
                        ++posOff2;
                    }
                    ++posP1;
                    continue;
                }
                if (Randomize.Rand() < 0.5) {
                    genesOff1[posOff1] = gen2.copy();
                    ++posOff1;
                } else {
                    genesOff2[posOff2] = gen2.copy();
                    ++posOff2;
                }
                ++posP2;
            }
            if (posP1 < p1.length()) {
                while (posP1 < p1.length()) {
                    gen1 = p1.getGen(posP1);
                    if (Randomize.Rand() < 0.5) {
                        genesOff1[posOff1] = gen1.copy();
                        ++posOff1;
                    } else {
                        genesOff2[posOff2] = gen1.copy();
                        ++posOff2;
                    }
                    ++posP1;
                }
            } else if (posP2 < p2.length()) {
                while (posP2 < p2.length()) {
                    gen2 = p2.getGen(posP2);
                    if (Randomize.Rand() < 0.5) {
                        genesOff1[posOff1] = gen2.copy();
                        ++posOff1;
                    } else {
                        genesOff2[posOff2] = gen2.copy();
                        ++posOff2;
                    }
                    ++posP2;
                }
            }
            Chromosome off1 = new Chromosome(genesOff1, posOff1);
            Chromosome off2 = new Chromosome(genesOff2, posOff2);
            if (off1.length() < 2) {
                off1.setFit(-5.0);
            } else {
                this.fitness(off1);
            }
            if (off2.length() < 2) {
                off2.setFit(-5.0);
            } else {
                this.fitness(off2);
            }
            if (!((off_best = off1.getFit() > off2.getFit() ? off1 : off2).getFit() > -5.0)) continue;
            pop.add(off_best);
        }
    }

    private void mutate(ArrayList<Chromosome> pop) {
        for (int i = 0; i < this.popsize; ++i) {
            double top;
            if (!(Randomize.Rand() < this.pm)) continue;
            Chromosome chromo = pop.get(i);
            int index = Randomize.Randint(0, chromo.length());
            Gene g = chromo.getGen(index);
            int attr = g.getAttr();
            double max_attr = this.ds.getMax(attr);
            double min_attr = this.ds.getMin(attr);
            if (g.getType() != 0) {
                if (g.getType() == 2) {
                    if (Randomize.Rand() < 0.5) {
                        if (Randomize.Rand() < 0.5) {
                            top = Math.max(g.getU() - this.allow_ampl[attr], min_attr);
                            g.setL(Randomize.RanddoubleClosed(top, g.getL()));
                        } else {
                            g.setL(Randomize.Randdouble(g.getL(), g.getU()));
                        }
                    } else if (Randomize.Rand() < 0.5) {
                        top = Math.min(g.getL() + this.allow_ampl[attr], max_attr);
                        g.setU(Randomize.RanddoubleClosed(g.getU(), top));
                    } else {
                        g.setU(Randomize.RanddoubleClosed(g.getL() + 1.0E-4, g.getU()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    if (Randomize.Rand() < 0.5) {
                        top = Math.max(g.getU() - this.allow_ampl[attr], min_attr);
                        g.setL(Randomize.RandintClosed((int)top, (int)g.getL()));
                    } else {
                        g.setL(Randomize.Randint((int)g.getL(), (int)g.getU()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    top = Math.min(g.getL() + this.allow_ampl[attr], max_attr);
                    g.setU(Randomize.RandintClosed((int)g.getU(), (int)top));
                } else {
                    g.setU(Randomize.RandintClosed((int)g.getL() + 1, (int)g.getU()));
                }
            } else {
                top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                g.setL(top);
                g.setU(top);
            }
            this.fitness(chromo);
        }
    }

    private void fitness(Chromosome c) {
        double nTrans = this.ds.getnTrans();
        ArrayList<Integer> tid_lst = this.countSupport(c.getGenes());
        ++this.trials;
        if ((double)tid_lst.size() < 1.0) {
            c.setFit(-5.0);
            c.setSupport(0.0);
        } else {
            double cov = (double)tid_lst.size() / nTrans;
            int cnt = 0;
            for (int t = 0; t < tid_lst.size(); ++t) {
                if (!this.marked[tid_lst.get(t)]) continue;
                ++cnt;
            }
            double already_covered = (double)cnt / nTrans;
            double ampl = this.amplitude(c.getGenes());
            double nAttr = (double)c.getGenes().length / (double)this.ds.getnVars();
            c.setFit(cov - already_covered * this.w - ampl * this.y + nAttr * this.u);
            c.setSupport(cov);
        }
    }

    private double amplitude(Gene[] genes) {
        double max_avg_curr = 0.0;
        double sum_curr_amp = 0.0;
        double sum_attr_amp = 0.0;
        for (int g = 0; g < genes.length; ++g) {
            int attr = genes[g].getAttr();
            double curr_amp = genes[g].getU() - genes[g].getL();
            double attr_amp = this.allow_ampl[attr];
            sum_curr_amp += curr_amp;
            sum_attr_amp += attr_amp;
            double avg_curr = curr_amp / attr_amp;
            if (!(avg_curr > max_avg_curr)) continue;
            max_avg_curr = avg_curr;
        }
        double avg_amp = sum_curr_amp / sum_attr_amp;
        return (avg_amp + max_avg_curr) / 2.0;
    }

    private ArrayList<Integer> countSupport(Gene[] genes) {
        ArrayList<Integer> tid_list = new ArrayList<Integer>();
        double[][] trans = this.ds.getRealTransactions();
        int nTrans = this.ds.getnTrans();
        for (int t = 0; t < nTrans; ++t) {
            boolean ok = true;
            for (int g = 0; g < genes.length && ok; ++g) {
                int attr = genes[g].getAttr();
                double lb = genes[g].getL();
                double ub = genes[g].getU();
                if (!(trans[t][attr] < lb) && !(trans[t][attr] > ub)) continue;
                ok = false;
            }
            if (!ok) continue;
            tid_list.add(t);
        }
        return tid_list;
    }

    private void penalizeRecordsCoveredBy(Chromosome c) {
        ArrayList<Integer> tid_lst = this.countSupport(c.getGenes());
        for (int t = 0; t < tid_lst.size(); ++t) {
            int tr = tid_lst.get(t);
            if (this.marked[tr]) continue;
            this.marked[tr] = true;
        }
    }

    private void genRules() {
        this.assoc_rules = new ArrayList();
        for (int i = 0; i < this.freqIts.size(); ++i) {
            Chromosome chromo = this.freqIts.get(i);
            ArrayList<Integer> tid_lst_all = this.countSupport(chromo.getGenes());
            Gene[] genes_ant = new Gene[chromo.length() - 1];
            Gene[] genes_cons = new Gene[1];
            for (int g1 = 0; g1 < chromo.length(); ++g1) {
                AssociationRule rule = new AssociationRule();
                int j = 0;
                for (int g2 = 0; g2 < chromo.length(); ++g2) {
                    if (g1 == g2) continue;
                    rule.addAntecedent(chromo.getGen(g2).copy());
                    genes_ant[j] = chromo.getGen(g2);
                    ++j;
                }
                rule.addConsequent(chromo.getGen(g1).copy());
                genes_cons[0] = chromo.getGen(g1);
                ArrayList<Integer> tid_lst_ant = this.countSupport(genes_ant);
                ArrayList<Integer> tid_lst_cons = this.countSupport(genes_cons);
                double all_sup = (double)tid_lst_all.size() / (double)this.ds.getnTrans();
                double ant_sup = (double)tid_lst_ant.size() / (double)this.ds.getnTrans();
                double cons_sup = (double)tid_lst_cons.size() / (double)this.ds.getnTrans();
                double conf = all_sup / ant_sup;
                double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : all_sup / (ant_sup * cons_sup);
                double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - all_sup);
                double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (all_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
                double numeratorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) - (ant_sup - all_sup) * (cons_sup - all_sup);
                double denominatorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) + (ant_sup - all_sup) * (cons_sup - all_sup);
                double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
                double CF = 0.0;
                if (conf > cons_sup) {
                    CF = (conf - cons_sup) / (1.0 - cons_sup);
                } else if (conf < cons_sup) {
                    CF = (conf - cons_sup) / cons_sup;
                }
                rule.setSupport_Ant(ant_sup);
                rule.setSupport_cons(cons_sup);
                rule.setAll_support(all_sup);
                rule.setConfidence(conf);
                rule.setLift(lift);
                rule.setConv(conv);
                rule.setCF(CF);
                rule.setNetConf(netConf);
                rule.setYulesQ(yulesQ);
                this.assoc_rules.add(rule);
            }
        }
    }

    private int numCoveredRecords(double minConfidence, double minSupport) {
        int i;
        for (i = 0; i < this.marked.length; ++i) {
            this.marked[i] = false;
        }
        for (i = 0; i < this.assoc_rules.size(); ++i) {
            int j;
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            ArrayList<Gene> ant = rule.getAntecedent();
            Gene[] genes = new Gene[ant.size()];
            for (j = 0; j < ant.size(); ++j) {
                genes[j] = ant.get(j);
            }
            ArrayList<Integer> tidCovered = this.countSupport(genes);
            for (j = 0; j < tidCovered.size(); ++j) {
                this.marked[tidCovered.get((int)j).intValue()] = true;
            }
        }
        int covered = 0;
        for (i = 0; i < this.marked.length; ++i) {
            if (!this.marked[i]) continue;
            ++covered;
        }
        return covered;
    }

    private double avgAmplitudeBestChromosome(Chromosome c) {
        Gene[] g = c.getGenes();
        double avg = 0.0;
        for (int i = 0; i < g.length; ++i) {
            avg += g[i].getU() - g[i].getL();
        }
        return avg / (double)g.length;
    }
}

