/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;
import java.util.HashSet;

public class SsfCalendarization
implements ISsf {
    private final double[] weights;
    private final HashSet<Integer> starts = new HashSet();
    private final HashSet<Integer> ends = new HashSet();
    private int curpos = -1;
    private int curtype = -1;
    public static final int LAST = 1;
    public static final int FIRST = 2;
    public static final int DEF = 0;

    public int posType(int pos) {
        if (this.curpos == pos) {
            return this.curtype;
        }
        this.curpos = pos;
        this.curtype = this.starts.contains(pos) ? 2 : (this.ends.contains(pos) ? 1 : 0);
        return this.curtype;
    }

    public SsfCalendarization(int[] starts, double[] w) {
        this.weights = w;
        for (int i = 0; i < starts.length; ++i) {
            int cur = starts[i];
            this.starts.add(cur);
            if (cur <= 0) continue;
            this.ends.add(cur - 1);
        }
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        b.set(1, 0, 1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(1, 1, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 1;
    }

    @Override
    public int getStateDim() {
        return 2;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        double k0 = k.get(0);
        double k1 = k.get(1);
        double w = this.weight(pos);
        int postype = this.posType(pos);
        if (postype == 1) {
            lm.set(0, 0, -k0);
            lm.set(0, 1, -w * k0);
            lm.set(1, 0, -k1);
            lm.set(1, 1, 1.0 - w * k1);
        } else if (postype == 2) {
            lm.set(0, 0, 0.0);
            lm.set(0, 1, w - w * k0);
            lm.set(1, 0, 0.0);
            lm.set(1, 1, 1.0 - w * k1);
        } else {
            lm.set(0, 0, 1.0 - k0);
            lm.set(0, 1, w - w * k0);
            lm.set(1, 0, -k1);
            lm.set(1, 1, 1.0 - w * k1);
        }
    }

    private double mweight(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * m;
    }

    private double mweight2(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * this.weights[pos] * m;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.set(1, 1, 1.0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        pi0.set(1, 1, 1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 1);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(1, 1, 1.0);
        int postype = this.posType(pos);
        if (postype != 1) {
            tr.set(0, 1, this.weight(pos));
            if (postype != 2) {
                tr.set(0, 0, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        int postype = this.posType(pos);
        if (postype == 1) {
            vm.set(0, 0, 0.0);
            vm.set(1, 0, 0.0);
            vm.set(0, 1, 0.0);
        } else if (postype == 2) {
            double w = this.weight(pos);
            double v = w * vm.get(1, 1);
            vm.set(0, 0, w * v);
            vm.set(1, 0, v);
            vm.set(0, 1, v);
        } else {
            double w = this.weight(pos);
            double wV = w * vm.get(1, 1);
            double wv = w * vm.get(0, 1);
            vm.add(0, 1, wV);
            vm.add(1, 0, wV);
            vm.add(0, 0, 2.0 * wv + w * wV);
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int postype = this.posType(pos);
        double s = this.mweight(pos, x.get(1));
        if (postype == 1) {
            x.set(0, 0.0);
        } else if (postype == 2) {
            x.set(0, s);
        } else {
            x.add(0, s);
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(1, 1, this.mweight2(pos, d));
        int postype = this.posType(pos);
        if (postype != 2) {
            double w = this.mweight(pos, d);
            vm.add(0, 0, d);
            vm.add(0, 1, w);
            vm.add(1, 0, w);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    private double weight(int pos) {
        return this.weights == null ? 1.0 : this.weights[pos];
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(1, this.mweight(pos, d));
        int postype = this.posType(pos);
        if (postype != 2) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        int postype = this.posType(pos);
        if (postype == 1) {
            x.set(0, 0.0);
        } else if (postype == 2) {
            x.add(1, this.mweight(pos, x.get(0)));
            x.set(0, 0.0);
        } else {
            x.add(1, this.mweight(pos, x.get(0)));
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        int postype = this.posType(pos);
        if (postype == 2) {
            z.set(0, 0.0);
        } else {
            z.set(0, 1.0);
        }
        z.set(1, this.weight(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.product(m.row(1), this.weight(pos));
        int postype = this.posType(pos);
        if (postype != 2) {
            x.add(m.row(0));
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        int postype = this.posType(pos);
        if (postype == 2) {
            return this.mweight2(pos, vm.get(1, 1));
        }
        double r = vm.get(0, 0);
        r += this.mweight(pos, 2.0 * vm.get(1, 0));
        return r += this.mweight2(pos, vm.get(1, 1));
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        int postype = this.posType(pos);
        double r = postype == 2 ? 0.0 : x.get(0);
        return r + this.mweight(pos, x.get(1));
    }
}

