/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.util.Attribute;
import dr.util.Identifiable;

public interface Statistic
extends Attribute<double[]>,
Identifiable,
Loggable {
    public static final String NAME = "name";

    public String getStatisticName();

    public String getDimensionName(int var1);

    public void setDimensionNames(String[] var1);

    public int getDimension();

    public double getStatisticValue(int var1);

    public double getValueSum();

    public static abstract class Abstract
    implements Statistic {
        private String name = null;
        protected String id = null;

        public Abstract() {
            this.name = null;
        }

        public Abstract(String string) {
            this.name = string;
        }

        @Override
        public String getStatisticName() {
            if (this.name != null) {
                return this.name;
            }
            if (this.id != null) {
                return this.id;
            }
            return this.getClass().toString();
        }

        @Override
        public String getDimensionName(int n) {
            if (this.getDimension() == 1) {
                return this.getStatisticName();
            }
            return this.getStatisticName() + Integer.toString(n + 1);
        }

        @Override
        public void setDimensionNames(String[] stringArray) {
        }

        @Override
        public double getValueSum() {
            double d = 0.0;
            for (int i = 0; i < this.getDimension(); ++i) {
                d += this.getStatisticValue(i);
            }
            return d;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getStatisticValue(0)));
            for (int i = 1; i < this.getDimension(); ++i) {
                stringBuffer.append(", ").append(String.valueOf(this.getStatisticValue(i)));
            }
            return stringBuffer.toString();
        }

        @Override
        public final String getAttributeName() {
            return this.getStatisticName();
        }

        @Override
        public double[] getAttributeValue() {
            double[] dArray = new double[this.getDimension()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.getStatisticValue(i);
            }
            return dArray;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public LogColumn[] getColumns() {
            LogColumn[] logColumnArray = new LogColumn[this.getDimension()];
            for (int i = 0; i < this.getDimension(); ++i) {
                logColumnArray[i] = new StatisticColumn(this.getDimensionName(i), i);
            }
            return logColumnArray;
        }

        private class StatisticColumn
        extends NumberColumn {
            private final int dim;

            public StatisticColumn(String string, int n) {
                super(string);
                this.dim = n;
            }

            @Override
            public double getDoubleValue() {
                return Abstract.this.getStatisticValue(this.dim);
            }
        }
    }
}

