/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.discrete.BranchDifferentialMassProvider;
import dr.evomodel.treedatalikelihood.discrete.DiscreteTraitBranchRateDelegate;
import dr.evomodel.treedatalikelihood.preorder.AbstractDiscreteTraitDelegate;

public class BranchSubstitutionParameterDelegate
extends AbstractDiscreteTraitDelegate {
    private final BranchRateModel branchRateModel;
    private final BranchDifferentialMassProvider branchDifferentialMassProvider;
    private final String name;
    private static final String GRADIENT_TRAIT_NAME = "BranchSubstitutionGradient";
    private static final String HESSIAN_TRAIT_NAME = "BranchSubstitutionHessian";

    BranchSubstitutionParameterDelegate(String string, Tree tree, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, BranchRateModel branchRateModel, BranchDifferentialMassProvider branchDifferentialMassProvider) {
        super(string, tree, beagleDataLikelihoodDelegate);
        this.name = string;
        this.branchRateModel = branchRateModel;
        this.branchDifferentialMassProvider = branchDifferentialMassProvider;
    }

    @Override
    protected void cacheDifferentialMassMatrix(Tree tree, boolean bl) {
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            NodeRef nodeRef = tree.getNode(i);
            if (tree.isRoot(nodeRef)) continue;
            double d = tree.getBranchLength(nodeRef) * this.branchRateModel.getBranchRate(tree, nodeRef);
            double[] dArray = this.branchDifferentialMassProvider.getDifferentialMassMatrixForBranch(nodeRef, d);
            double[] dArray2 = DiscreteTraitBranchRateDelegate.scaleInfinitesimalMatrixByRates(dArray, DiscreteTraitBranchRateDelegate.DifferentialChoice.GRADIENT, this.siteRateModel);
            this.evolutionaryProcessDelegate.cacheFirstOrderDifferentialMatrix(this.beagle, i, dArray2);
        }
        if (bl) {
            throw new RuntimeException("Not yet implemented!");
        }
    }

    @Override
    protected int getFirstDerivativeMatrixBufferIndex(int n) {
        return this.evolutionaryProcessDelegate.getFirstOrderDifferentialMatrixBufferIndex(n);
    }

    @Override
    protected int getSecondDerivativeMatrixBufferIndex(int n) {
        return this.evolutionaryProcessDelegate.getSecondOrderDifferentialMatrixBufferIndex(n);
    }

    @Override
    protected String getGradientTraitName() {
        return "BranchSubstitutionGradient:" + this.name;
    }

    @Override
    protected String getHessianTraitName() {
        return "BranchSubstitutionHessian:" + this.name;
    }

    public static String getName(String string) {
        return "BranchSubstitutionGradient:" + string;
    }
}

