/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sparklyr.DFCollectionUtils$;
import sparklyr.Logger;
import sparklyr.PartitionUtils$;
import sparklyr.RUtils$;

public final class RDSCollector$ {
    public static RDSCollector$ MODULE$;

    static {
        new RDSCollector$();
    }

    public void collect(Dataset<Row> df, Seq<String> outputFiles) {
        int numPartitions = df.rdd().getNumPartitions();
        if (outputFiles.length() != numPartitions) {
            throw new IllegalArgumentException(new StringBuilder(87).append("Number of output file(s) does not match input dataframe's number of partitions (").append(outputFiles.length()).append(" vs. ").append(numPartitions).append(").").toString());
        }
        Tuple2<Dataset<Row>, Tuple2<String, String>[]> tuple2 = DFCollectionUtils$.MODULE$.prepareDataFrameForCollection(df);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset transformedDf = (Dataset)tuple2._1();
        Tuple2[] dtypes = (Tuple2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transformedDf, (Object)dtypes);
        Tuple2 tuple23 = tuple22;
        Dataset transformedDf2 = (Dataset)tuple23._1();
        Tuple2[] dtypes2 = (Tuple2[])tuple23._2();
        transformedDf2.cache();
        int[] partitionSizes = new int[numPartitions];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PartitionUtils$.MODULE$.computePartitionSizes((Dataset<Row>)transformedDf2))).foreach((Function1 & Serializable & scala.Serializable)p -> {
            RDSCollector$.$anonfun$collect$1(partitionSizes, p);
            return BoxedUnit.UNIT;
        });
        this.writeHeaders(transformedDf2.sqlContext().sparkContext(), outputFiles, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])dtypes2));
        String[] cols = transformedDf2.columns();
        Configuration hadoopConf = transformedDf2.sqlContext().sparkContext().hadoopConfiguration();
        SerializableWritable serializedHadoopConf = new SerializableWritable((Writable)hadoopConf);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cols.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            Dataset colDf = transformedDf2.select(cols[idx], (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            colDf.cache();
            colDf.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
                RDSCollector$.$anonfun$collect$3(serializedHadoopConf, outputFiles, idx, partitionSizes, dtypes2, iter);
                return BoxedUnit.UNIT;
            });
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Logger logger = new Logger("RDSCollector", 0);
        FileSystem fs = FileSystem.get((Configuration)hadoopConf);
        outputFiles.foreach((Function1 & Serializable & scala.Serializable)o -> {
            RDSCollector$.$anonfun$collect$4(cols, fs, logger, o);
            return BoxedUnit.UNIT;
        });
    }

    private void writeHeaders(SparkContext sc, Seq<String> outputFiles, Seq<Tuple2<String, String>> dtypes) {
        FileSystem fs = FileSystem.get((Configuration)sc.hadoopConfiguration());
        ((IterableLike)outputFiles.map((Function1 & Serializable & scala.Serializable)p -> fs.create(new Path(new StringBuilder(4).append((String)p).append(".hdr").toString())), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)fos -> {
            RDSCollector$.$anonfun$writeHeaders$2(dtypes, fos);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collect$1(int[] partitionSizes$1, int[] p) {
        int partitionSize;
        int partitionId = p[0];
        partitionSizes$1[partitionId] = partitionSize = p[1];
    }

    public static final /* synthetic */ void $anonfun$collect$3(SerializableWritable serializedHadoopConf$1, Seq outputFiles$1, int idx$1, int[] partitionSizes$1, Tuple2[] dtypes$1, Iterator iter) {
        FileSystem fs = FileSystem.get((Configuration)((Configuration)serializedHadoopConf$1.value()));
        FSDataOutputStream fos = fs.create(new Path(new StringBuilder(5).append((String)outputFiles$1.apply(TaskContext$.MODULE$.getPartitionId())).append(".col_").append(idx$1).toString()));
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            RUtils$.MODULE$.writeColumn(dos, partitionSizes$1[TaskContext$.MODULE$.getPartitionId()], (Iterator<Row>)iter, (String)dtypes$1[idx$1]._2());
        }
        finally {
            dos.close();
            bos.close();
            fos.close();
        }
    }

    public static final /* synthetic */ String $anonfun$collect$5(String o$1, int idx) {
        return new StringBuilder(5).append(o$1).append(".col_").append(idx).toString();
    }

    public static final /* synthetic */ int $anonfun$collect$8(SeekableByteChannel ch$1, java.nio.file.Path path) {
        int n;
        try (FileChannel pch = FileChannel.open(path, StandardOpenOption.READ);){
            MappedByteBuffer buf = pch.map(FileChannel.MapMode.READ_ONLY, 0L, pch.size());
            n = ch$1.write(buf);
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$collect$4(String[] cols$1, FileSystem fs$1, Logger logger$1, String o) {
        String[] inputs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{new StringBuilder(4).append(o).append(".hdr").toString()})).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cols$1.length).map((Function1 & Serializable & scala.Serializable)idx -> RDSCollector$.$anonfun$collect$5(o, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Path[] paths = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).map((Function1 & Serializable & scala.Serializable)x -> new Path(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        FileSystem fileSystem = fs$1;
        if (fileSystem instanceof LocalFileSystem) {
            BoxedUnit boxedUnit;
            java.nio.file.Path[] localPaths = (java.nio.file.Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).map((Function1 & Serializable & scala.Serializable)x -> Paths.get(new URI((String)x).getPath(), new String[0]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.nio.file.Path.class)));
            try (SeekableByteChannel ch = Files.newByteChannel(Paths.get(new URI(o).getPath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localPaths)).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToInteger((int)RDSCollector$.$anonfun$collect$8(ch, path)));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            Path dst = new Path(o);
            fs$1.createNewFile(dst);
            fs$1.concat(dst, paths);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths)).foreach((Function1 & Serializable & scala.Serializable)path -> {
            Boolean bl;
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)fs$1.delete(path, false));
            }
            catch (Throwable e) {
                logger$1.logWarning(new StringBuilder(34).append("Failed to delete temporary file ").append(path).append(": ").append(e.toString()).toString());
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public static final /* synthetic */ void $anonfun$writeHeaders$2(Seq dtypes$2, FSDataOutputStream fos) {
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            RUtils$.MODULE$.writeXdrHeader(dos);
            RUtils$.MODULE$.writeDataFrameHeader(dos, (Seq<Tuple2<String, String>>)dtypes$2);
        }
        finally {
            dos.close();
            bos.close();
            fos.close();
        }
    }

    private RDSCollector$() {
        MODULE$ = this;
    }
}

