/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;
import org.vikamine.kernel.subgroup.quality.EstimatetableQFSimpleStatisticsBased;

public class SymmetricStandardQF
extends AbstractQFSimpleStatisticBased
implements EstimatetableQFSimpleStatisticsBased {
    private static final String ID = "Symmetric StandardQF";
    double a;

    public SymmetricStandardQF(double a) {
        this.a = a;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return "Symmetric standard quality function, a=" + this.a;
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluateNum(double subgroupSize, double sgMean, double definedPopulationCount, double populationMean) {
        return Math.pow(subgroupSize, this.a) * Math.abs(sgMean - populationMean);
    }

    @Override
    public double evaluateBin(double subgroupSize, double tp, double definedPopulationCount, double populationPositives) {
        return Math.pow(subgroupSize, this.a) * Math.abs(tp / subgroupSize - populationPositives / definedPopulationCount);
    }

    @Override
    public double estimateQuality(double subgroupSize, double subgroupPositives, double populationSize, double populationPositives) {
        double p0 = populationPositives / populationSize;
        double deviation = Math.max(1.0 - p0, p0);
        return Math.pow(subgroupSize, this.a) * deviation;
    }

    @Override
    public SymmetricStandardQF clone() {
        return new SymmetricStandardQF(this.a);
    }

    public double getParam() {
        return this.a;
    }
}

