/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.causality;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.FilteringDataRecordIterator;
import org.vikamine.kernel.data.IncludingDataRecordFilter;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.statistics.ChiSquareStatistics;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.analysis.causality.CausalSGNet;
import org.vikamine.kernel.subgroup.analysis.causality.CausalSGNode;
import org.vikamine.kernel.subgroup.analysis.causality.CausalSGNodeFactory;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.selectors.BooleanTargetAdapterSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.util.VKMUtil;

public class CausalSGAnalyzer {
    private Ontology onto;
    private double approximateEqualsThreshold = 0.8;
    private final double c1 = 1.0;
    private final SGPairSet excludedCausalitySet = new SGPairSet();
    private final SGPairSet conditionallyExcludedCausalitySet = new SGPairSet();
    private final Separators separators = new Separators();
    private final Collection directlyIncludedSubgroups;
    private final SG targetSG;
    private final DataView population;
    private CausalSGNet causalSGNet = null;
    private final Map approxEqualSubgroups = new HashMap();
    private final SGSet sgSet;
    private final IQualityFunction qf;
    private static boolean trace = true;

    public Ontology getOnto() {
        return this.onto;
    }

    public void setOnto(Ontology onto) {
        this.onto = onto;
    }

    public CausalSGAnalyzer(DataView population, SGSet sgSet, BooleanTarget target, Options options, IQualityFunction qf) {
        this.population = population;
        this.sgSet = sgSet;
        this.directlyIncludedSubgroups = VKMUtil.asList(sgSet.iterator());
        this.qf = qf;
        this.targetSG = this.createTargetSG(target, options);
    }

    private boolean isConditionallyExcluded(SG i, SG j) {
        return this.conditionallyExcludedCausalitySet.contains(i, j);
    }

    private boolean isDirectlyExcluded(SG i, SG j) {
        return this.excludedCausalitySet.contains(i, j);
    }

    private boolean isDirectlyOrConditionallyExcluded(SG i, SG j) {
        return this.isDirectlyExcluded(i, j) || this.isConditionallyExcluded(i, j);
    }

    private static void trace(String msg) {
        if (trace) {
            System.out.println(msg);
        }
    }

    private void addApproxEqualSubgroup(SG parent, SG approxEqualSG) {
        LinkedList<SG> approxEqualSgsForParent = (LinkedList<SG>)this.approxEqualSubgroups.get(parent);
        if (approxEqualSgsForParent == null) {
            approxEqualSgsForParent = new LinkedList<SG>();
            this.approxEqualSubgroups.put(parent, approxEqualSgsForParent);
        }
        approxEqualSgsForParent.add(approxEqualSG);
    }

    private SG createTargetSG(BooleanTarget target, Options options) {
        SG sg = new SG(this.population, target);
        SGDescription sgd = new SGDescription();
        sgd.add(new BooleanTargetAdapterSelector(target));
        sg.setSGDescription(sgd);
        sg.createStatistics(options);
        sg.setQuality(this.qf.evaluate(sg));
        return sg;
    }

    public void refine() {
        this.applySGCausalityStep0();
        this.applySGCausalityStep1();
        this.applySGCausalityStep2();
        this.applySGCausalityStep3();
        this.applySGCausalityStep4();
        this.applyCCURule();
        this.applyModifiedCCCRule();
        this.addAllDirectACausalEdges();
        this.addAllRemainingCCAssociations();
        this.recalculateNodeLevels();
    }

    private void recalculateNodeLevels() {
        this.getCausalSGNet().recalculateLevelsAllowingCircles();
    }

    private void applySGCausalityStep0() {
        for (SG sgI : this.directlyIncludedSubgroups) {
            if (!this.testIndependent(sgI, this.targetSG)) continue;
            this.excludedCausalitySet.add(sgI, this.targetSG);
        }
    }

    private void applySGCausalityStep1() {
        LinkedList<SG> approxEqualSubgroups = new LinkedList<SG>();
        for (SG sgI : this.directlyIncludedSubgroups) {
            if (sgI.getTarget().isNumeric()) {
                throw new IllegalArgumentException("Not applicable for subgroups with numeric targets");
            }
            if (approxEqualSubgroups.contains(sgI)) continue;
            for (SG sgJ : this.directlyIncludedSubgroups) {
                if (sgJ.getTarget().isNumeric()) {
                    throw new IllegalArgumentException("Not applicable for subgroups with numeric targets");
                }
                if (sgI.equals(sgJ) || approxEqualSubgroups.contains(sgJ)) continue;
                if (this.isApproximateEqual(sgI, sgJ)) {
                    SG excludedSG = SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)sgI.getStatistics()) > SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)sgJ.getStatistics()) ? sgJ : sgI;
                    this.addApproxEqualSubgroup(excludedSG.equals(sgI) ? sgJ : sgI, excludedSG);
                    approxEqualSubgroups.add(excludedSG);
                    continue;
                }
                if (!this.testIndependent(sgI, sgJ)) continue;
                this.excludedCausalitySet.add(sgI, sgJ);
            }
        }
        this.directlyIncludedSubgroups.removeAll(approxEqualSubgroups);
    }

    private void applySGCausalityStep2() {
        SGPairSet inhibitedSymmetricPairs = new SGPairSet();
        for (SG sgI : this.directlyIncludedSubgroups) {
            for (SG sgJ : this.directlyIncludedSubgroups) {
                if (sgI.equals(sgJ) || this.isDirectlyOrConditionallyExcluded(sgI, this.targetSG) && (this.isDirectlyOrConditionallyExcluded(sgJ, this.targetSG) && this.isDirectlyOrConditionallyExcluded(sgI, sgJ) || inhibitedSymmetricPairs.contains(sgI, sgJ)) || !this.testCondIndependent(sgI, this.targetSG, sgJ)) continue;
                if (this.testCondIndependent(sgJ, this.targetSG, sgI)) {
                    inhibitedSymmetricPairs.add(sgI, sgJ);
                    double chi2SGI = CausalSGAnalyzer.calculateChiSquareValue(sgI, this.targetSG, this.targetSG.getPopulation());
                    double chi2SGJ = CausalSGAnalyzer.calculateChiSquareValue(sgJ, this.targetSG, this.targetSG.getPopulation());
                    if (chi2SGI < chi2SGJ) {
                        this.conditionallyExcludedCausalitySet.add(sgI, this.targetSG);
                        this.separators.addSeparator(sgJ, sgI, this.targetSG);
                        continue;
                    }
                    this.conditionallyExcludedCausalitySet.add(sgJ, this.targetSG);
                    this.separators.addSeparator(sgI, sgJ, this.targetSG);
                    continue;
                }
                this.conditionallyExcludedCausalitySet.add(sgI, this.targetSG);
                this.separators.addSeparator(sgJ, sgI, this.targetSG);
            }
        }
    }

    private void applySGCausalityStep3() {
        for (SG sgI : this.directlyIncludedSubgroups) {
            for (SG sgJ : this.directlyIncludedSubgroups) {
                if (sgI.equals(sgJ) || this.isDirectlyOrConditionallyExcluded(sgI, sgJ) && this.isDirectlyOrConditionallyExcluded(sgI, this.targetSG) && this.isDirectlyOrConditionallyExcluded(sgJ, this.targetSG) || !this.testCondIndependent(sgI, sgJ, this.targetSG)) continue;
                this.conditionallyExcludedCausalitySet.add(sgI, sgJ);
                this.separators.addSeparator(this.targetSG, sgI, sgJ);
            }
        }
    }

    private void applySGCausalityStep4() {
        for (SG sgI : this.directlyIncludedSubgroups) {
            for (SG sgJ : this.directlyIncludedSubgroups) {
                if (sgI.equals(sgJ)) continue;
                for (SG sgK : this.directlyIncludedSubgroups) {
                    if (sgJ.equals(sgK) || sgI.equals(sgK) || this.isDirectlyOrConditionallyExcluded(sgI, sgJ) && this.isDirectlyOrConditionallyExcluded(sgI, sgK) && this.isConditionallyExcluded(sgJ, sgK) || !this.testCondIndependent(sgI, sgJ, sgK)) continue;
                    this.conditionallyExcludedCausalitySet.add(sgI, sgJ);
                    this.separators.addSeparator(sgK, sgI, sgJ);
                }
            }
        }
    }

    private void applyCCURule() {
        LinkedList<SG> allIncludedSubgroupsInNet = new LinkedList<SG>(VKMUtil.asList(this.sgSet.iterator()));
        LinkedList<SG> allIncludedSubgroups = new LinkedList<SG>(this.directlyIncludedSubgroups);
        allIncludedSubgroups.add(this.targetSG);
        allIncludedSubgroupsInNet.add(this.targetSG);
        this.initializeCausalNet(allIncludedSubgroupsInNet);
        HashSet triplesDone = new HashSet();
        for (SG sgI : allIncludedSubgroups) {
            for (SG sgJ : allIncludedSubgroups) {
                if (sgI.equals(sgJ) || !this.excludedCausalitySet.contains(sgI, sgJ)) continue;
                for (SG sgK : allIncludedSubgroups) {
                    SGTriple triple = new SGTriple(sgI, sgJ, sgK);
                    if (triplesDone.contains(triple) || sgJ.equals(sgK) || sgI.equals(sgK) || this.isDirectlyOrConditionallyExcluded(sgJ, sgK) || this.isDirectlyOrConditionallyExcluded(sgI, sgK) || !this.excludedCausalitySet.contains(sgI, sgJ) || this.separators.isSeparator(sgK, sgI, sgJ)) continue;
                    CausalSGNode nodeI = this.causalSGNet.getNode(sgI);
                    CausalSGNode nodeJ = this.causalSGNet.getNode(sgJ);
                    CausalSGNode nodeK = this.causalSGNet.getNode(sgK);
                    CausalSGAnalyzer.trace("Applying CCU");
                    if (CausalSGNodeFactory.isACausalSubgroup(sgK, this.onto)) {
                        CausalSGAnalyzer.trace("Introducing acausal association!");
                        nodeI.addChild(nodeK);
                        nodeJ.addChild(nodeK);
                    } else {
                        nodeI.addChild(nodeK);
                        nodeJ.addChild(nodeK);
                    }
                    CausalSGAnalyzer.trace("-------------");
                }
            }
        }
    }

    private void initializeCausalNet(Collection allIncludedSubgroups) {
        this.causalSGNet = new CausalSGNet();
        for (SG sg : allIncludedSubgroups) {
            CausalSGNode node = sg.equals(this.targetSG) ? CausalSGNodeFactory.getInstance().createTargetSGNode(sg) : CausalSGNodeFactory.getInstance().createCausalSGNode(sg, this.onto);
            Collection approxEquals = (Collection)this.approxEqualSubgroups.get(sg);
            if (approxEquals == null) {
                approxEquals = Collections.EMPTY_LIST;
            }
            node.setApproxEqualSubgroups(new HashSet(approxEquals));
            this.causalSGNet.addNode(node);
        }
    }

    private void applyModifiedCCCRule() {
        LinkedList<SG> allIncludedSubgroups = new LinkedList<SG>(this.directlyIncludedSubgroups);
        allIncludedSubgroups.add(this.targetSG);
        HashSet triplesDone = new HashSet();
        for (SG sgI : allIncludedSubgroups) {
            for (SG sgJ : allIncludedSubgroups) {
                if (sgI.equals(sgJ)) continue;
                for (SG sgK : allIncludedSubgroups) {
                    SGTriple triple;
                    if (sgJ.equals(sgK) || sgI.equals(sgK) || triplesDone.contains(triple = new SGTriple(sgI, sgJ, sgK)) || this.isDirectlyOrConditionallyExcluded(sgI, sgJ) || this.isDirectlyOrConditionallyExcluded(sgJ, sgK) || this.excludedCausalitySet.contains(sgI, sgK) || !this.separators.isSeparator(sgJ, sgI, sgK)) continue;
                    CausalSGNode nodeI = this.causalSGNet.getNode(sgI);
                    CausalSGNode nodeJ = this.causalSGNet.getNode(sgJ);
                    CausalSGNode nodeK = this.causalSGNet.getNode(sgK);
                    boolean causalRelationAdded = false;
                    CausalSGAnalyzer.trace("Trying to apply ModCCC");
                    if (CausalSGNodeFactory.isACausalSubgroup(sgI, this.onto) || this.getCausalSGNet().getNode(sgI).getChildren().contains(nodeJ) && !nodeJ.getChildren().contains(nodeK) && !nodeK.getChildren().contains(nodeJ)) {
                        causalRelationAdded = true;
                        CausalSGAnalyzer.trace("Applying ModCCC");
                        if (!nodeI.getChildren().contains(nodeJ)) {
                            nodeI.addChild(nodeJ);
                        }
                        if (CausalSGNodeFactory.isACausalSubgroup(sgK, this.onto)) {
                            CausalSGAnalyzer.trace("Applying ModCCC - Introducing acausal direction:");
                        }
                        nodeJ.addChild(nodeK);
                    }
                    if (CausalSGNodeFactory.isACausalSubgroup(sgJ, this.onto) || this.getCausalSGNet().getNode(sgJ).getChildren().contains(nodeI) && !nodeJ.getChildren().contains(nodeK) && !nodeK.getChildren().contains(nodeJ)) {
                        causalRelationAdded = true;
                        CausalSGAnalyzer.trace("Applying ModCCC");
                        if (!nodeJ.getChildren().contains(nodeI)) {
                            nodeJ.addChild(nodeI);
                        }
                        if (CausalSGNodeFactory.isACausalSubgroup(sgK, this.onto)) {
                            CausalSGAnalyzer.trace("Applying ModCCC - Introducing acausal direction!");
                        }
                        nodeJ.addChild(nodeK);
                    }
                    if (CausalSGNodeFactory.isACausalSubgroup(sgJ, this.onto) || this.getCausalSGNet().getNode(sgJ).getChildren().contains(nodeK) && !nodeJ.getChildren().contains(nodeI) && !nodeI.getChildren().contains(nodeJ)) {
                        causalRelationAdded = true;
                        CausalSGAnalyzer.trace("Applying ModCCC");
                        if (!nodeJ.getChildren().contains(nodeK)) {
                            nodeJ.addChild(nodeK);
                        }
                        if (CausalSGNodeFactory.isACausalSubgroup(sgI, this.onto)) {
                            CausalSGAnalyzer.trace("Applying ModCCC - Introducing acausal direction!");
                        }
                        nodeJ.addChild(nodeI);
                    }
                    if (CausalSGNodeFactory.isACausalSubgroup(sgK, this.onto) || this.getCausalSGNet().getNode(sgK).getChildren().contains(nodeJ) && !nodeJ.getChildren().contains(nodeI) && !nodeI.getChildren().contains(nodeJ)) {
                        causalRelationAdded = true;
                        CausalSGAnalyzer.trace("Applying ModCCC");
                        if (!nodeK.getChildren().contains(nodeJ)) {
                            nodeK.addChild(nodeJ);
                        }
                        if (CausalSGNodeFactory.isACausalSubgroup(sgJ, this.onto)) {
                            CausalSGAnalyzer.trace("Applying ModCCC - Introducing acausal direction!");
                        }
                        nodeK.addChild(nodeJ);
                    }
                    if (!causalRelationAdded) {
                        CausalSGAnalyzer.trace("Applying ModCCC - Introducing bare associations");
                        nodeI.addCCAssociation(nodeJ);
                        nodeJ.addCCAssociation(nodeK);
                    }
                    CausalSGAnalyzer.trace("-------------");
                }
            }
        }
    }

    private void addAllDirectACausalEdges() {
        LinkedList<SG> allIncludedSubgroups = new LinkedList<SG>(this.directlyIncludedSubgroups);
        allIncludedSubgroups.add(this.targetSG);
        for (SG sgI : allIncludedSubgroups) {
            if (!CausalSGNodeFactory.isACausalSubgroup(sgI, this.onto)) continue;
            for (SG sgJ : allIncludedSubgroups) {
                if (sgI.equals(sgJ) || this.isDirectlyOrConditionallyExcluded(sgI, sgJ) || this.causalSGNet.getNode(sgI).getChildren().contains(this.causalSGNet.getNode(sgJ))) continue;
                CausalSGAnalyzer.trace("Adding direct causal edge!");
                this.causalSGNet.getNode(sgI).addChild(this.causalSGNet.getNode(sgJ));
            }
        }
    }

    private void addAllRemainingCCAssociations() {
        LinkedList<SG> allIncludedSubgroups = new LinkedList<SG>(this.directlyIncludedSubgroups);
        allIncludedSubgroups.add(this.targetSG);
        for (SG sgI : allIncludedSubgroups) {
            for (SG sgJ : allIncludedSubgroups) {
                if (sgI.equals(sgJ) || this.isConditionallyExcluded(sgI, sgJ)) continue;
                CausalSGNode nodeI = this.causalSGNet.getNode(sgI);
                CausalSGNode nodeJ = this.causalSGNet.getNode(sgJ);
                if (nodeI.getChildren().contains(nodeJ) || nodeJ.getChildren().contains(nodeI) || nodeI.getCCAssociations().contains(nodeJ) || nodeJ.getCCAssociations().contains(nodeJ)) continue;
                CausalSGAnalyzer.trace("Adding non-excluded association");
                nodeI.addCCAssociation(nodeJ);
            }
        }
    }

    private boolean isApproximateEqual(SG currentSG, SG otherSG) {
        double currentSGsize = currentSG.getStatistics().getSubgroupSize();
        double otherSGsize = otherSG.getStatistics().getSubgroupSize();
        double intersectSize = CausalSGAnalyzer.calculateIntersectionSize(currentSG, otherSG);
        double value = intersectSize / (currentSGsize + otherSGsize - intersectSize);
        return value > this.approximateEqualsThreshold;
    }

    private double calculateConditionedChiSquareValue(SG currentSG, SG otherSG, SG conditionedSG, final boolean isPositiveConditioned) {
        final SGDescription conditionedSGDescription = conditionedSG.getSGDescription();
        return CausalSGAnalyzer.calculateChiSquareValueConditionedOnPopulation(currentSG, otherSG, conditionedSG.getPopulation().instanceIterator(), new IncludingDataRecordFilter(){

            @Override
            public boolean isIncluded(DataRecord instance) {
                if (conditionedSGDescription.isMatching(instance)) {
                    return isPositiveConditioned;
                }
                return !isPositiveConditioned;
            }
        });
    }

    private double calculateChiSquareValue(SG a, SG b) {
        return CausalSGAnalyzer.calculateChiSquareValue(a, b, this.population);
    }

    public static double calculateChiSquareValue(SG a, SG b, DataView refPopulation) {
        return CausalSGAnalyzer.calculateChiSquareValueConditionedOnPopulation(a, b, refPopulation.instanceIterator(), new IncludingDataRecordFilter(){

            @Override
            public boolean isIncluded(DataRecord instance) {
                return true;
            }
        });
    }

    private static double calculateChiSquareValueConditionedOnPopulation(SG a, SG b, Iterator<DataRecord> instanceIterator, IncludingDataRecordFilter filter) {
        int countA = 0;
        int countB = 0;
        int countAAndB = 0;
        int countNotAAndNotB = 0;
        FilteringDataRecordIterator instIter = new FilteringDataRecordIterator(instanceIterator, filter);
        while (instIter.hasNext()) {
            DataRecord inst = instIter.next();
            if (!a.getStatistics().isInstanceDefinedForSubgroupVars(inst) || !b.getStatistics().isInstanceDefinedForSubgroupVars(inst)) continue;
            if (a.getSGDescription().isMatching(inst)) {
                ++countA;
            }
            if (b.getSGDescription().isMatching(inst)) {
                ++countB;
            }
            if (a.getSGDescription().isMatching(inst) && b.getSGDescription().isMatching(inst)) {
                ++countAAndB;
                continue;
            }
            if (a.getSGDescription().isMatching(inst) || b.getSGDescription().isMatching(inst)) continue;
            ++countNotAAndNotB;
        }
        int countAAndNotB = countA - countAAndB;
        int countNotAAndB = countB - countAAndB;
        return ChiSquareStatistics.computeFourFoldChiSqare(countAAndB, countNotAAndB, countAAndNotB, countNotAAndNotB);
    }

    private boolean testCondIndependent(SG currentSG, SG otherSG, SG conditionedSG) {
        double chiQuadrat = this.calculateConditionedChiSquareValue(currentSG, otherSG, conditionedSG, true);
        return (chiQuadrat += this.calculateConditionedChiSquareValue(currentSG, otherSG, conditionedSG, false)) < 2.0;
    }

    public static int calculateIntersectionSize(SG currentSG, SG otherSG) {
        int size = 0;
        Iterator<DataRecord> subgroupInstanceIterator = currentSG.subgroupInstanceIterator();
        while (subgroupInstanceIterator.hasNext()) {
            DataRecord inst = subgroupInstanceIterator.next();
            try {
                if (!otherSG.getSGDescription().isMatching(inst)) continue;
                ++size;
            }
            catch (NullPointerException e) {
                Logger.getLogger(CausalSGAnalyzer.class.getName()).throwing(CausalSGAnalyzer.class.getName(), "calculateIntersectionSize", e);
            }
        }
        return size;
    }

    private boolean testIndependent(SG currentSG, SG otherSG) {
        return this.calculateChiSquareValue(currentSG, otherSG) < 1.0;
    }

    public double getApproximateEqualsThreshold() {
        return this.approximateEqualsThreshold;
    }

    public void setApproximateEqualsThreshold(double d) {
        this.approximateEqualsThreshold = d;
    }

    public CausalSGNet getCausalSGNet() {
        return this.causalSGNet;
    }

    protected SGSet getSgSet() {
        return this.sgSet;
    }

    private static class SGPair {
        private final Set pairSet = new HashSet();

        private SGPair(SG i, SG j) {
            this.pairSet.add(i);
            this.pairSet.add(j);
        }

        public int hashCode() {
            return this.pairSet.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            SGPair otherPair = (SGPair)other;
            return this.pairSet.equals(otherPair.pairSet);
        }

        public boolean contains(SG sg) {
            return this.pairSet.contains(sg);
        }

        public String toString() {
            return this.pairSet.toString();
        }
    }

    private static class SGPairSet {
        private final Set pairs = new HashSet();

        private SGPair createPair(SG i, SG j) {
            SGPair pair = new SGPair(i, j);
            return pair;
        }

        public void add(SG i, SG j) {
            SGPair pair = this.createPair(i, j);
            this.pairs.add(pair);
        }

        public boolean contains(SG i, SG j) {
            SGPair pair = this.createPair(i, j);
            return this.pairs.contains(pair);
        }
    }

    private static class SGTriple {
        private final Set triple = new HashSet();

        private SGTriple(SG i, SG j, SG k) {
            this.triple.add(i);
            this.triple.add(j);
            this.triple.add(k);
        }

        public int hashCode() {
            return this.triple.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            SGTriple otherPair = (SGTriple)other;
            return this.triple.equals(otherPair.triple);
        }

        public String toString() {
            return this.triple.toString();
        }
    }

    private static class Separators {
        private final HashMap separators = new HashMap();

        private Separators() {
        }

        public void addSeparator(SG sep, SG a, SG b) {
            SGPair pair = new SGPair(a, b);
            LinkedList<SGPair> sepValues = (LinkedList<SGPair>)this.separators.get(sep);
            if (sepValues == null) {
                sepValues = new LinkedList<SGPair>();
            }
            sepValues.add(pair);
            this.separators.put(sep, sepValues);
        }

        public boolean isSeparator(SG sep, SG a, SG b) {
            List values = (List)this.separators.get(sep);
            if (values != null) {
                int i = 0;
                while (i < values.size()) {
                    SGPair pair = (SGPair)values.get(i);
                    if (pair.contains(a) && pair.contains(b)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (Map.Entry entry : this.separators.entrySet()) {
                SG seperator = (SG)entry.getKey();
                List separatedSGs = (List)entry.getValue();
                result.append("Sep: " + seperator.toString() + "\n Separating:\n");
                for (SGPair separatedSGPair : separatedSGs) {
                    result.append("\t" + separatedSGPair);
                }
                result.append("\n");
            }
            return result.toString();
        }
    }
}

