/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.memory.IStateBool;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.OneValueDelta;
import org.chocosolver.solver.variables.delta.monitor.OneValueDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public abstract class BoolIntView<I extends IntVar>
extends IntView<I>
implements BoolVar {
    protected IStateBool fixed;
    public final int cste;
    private BoolVar not;
    private boolean isNot = false;
    protected IEnumDelta delta = NoDelta.singleton;
    protected boolean reactOnRemoval = false;

    protected BoolIntView(I var, String op, int cste) {
        super("(" + var.getName() + op + cste + ")", var);
        this.cste = cste;
        this.fixed = var.getModel().getEnvironment().makeBool(false);
    }

    @Override
    public final void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (!this.fixed.get() && this.isInstantiated()) {
            this.fixed.set(Boolean.TRUE);
            super.notify(event, variableIdx);
        }
    }

    @Override
    public final boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public final boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public final boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value == 0) {
            return this.instantiateTo(1, cause);
        }
        if (value == 1) {
            return this.instantiateTo(0, cause);
        }
        return false;
    }

    @Override
    public final boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (!values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (!values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (from <= to && from <= 1 && to >= 0) {
            if (from == 1) {
                hasChanged = this.instantiateTo(0, cause);
            } else if (to == 0) {
                hasChanged = this.instantiateTo(1, cause);
            } else {
                this.model.getSolver().getEventObserver().instantiateTo(this, 2, cause, 0, 1);
                this.contradiction(cause, "empty domain");
            }
        }
        return hasChanged;
    }

    @Override
    public final boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value > 0 && this.instantiateTo(value, cause);
    }

    @Override
    public final boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value < 1 && this.instantiateTo(value, cause);
    }

    @Override
    public final boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (lb > 1 || ub < 0) {
            this.model.getSolver().getEventObserver().instantiateTo(this, 2, cause, 0, 1);
            this.contradiction(cause, "empty domain");
        } else if (lb == 1) {
            hasChanged = this.instantiateTo(1, cause);
        } else if (ub == 0) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final int getTypeAndKind() {
        return 28;
    }

    @Override
    public final int getValue() {
        return this.getLB();
    }

    protected final EvtScheduler createScheduler() {
        return new BoolEvtScheduler();
    }

    @Override
    public final String toString() {
        if (this.isInstantiated()) {
            return this.name + " = " + this.getValue();
        }
        return this.name + " = [0,1]";
    }

    @Override
    public final DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public final DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public final void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new OneValueDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IDelta getDelta() {
        return this.delta;
    }

    @Override
    public final IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new OneValueDeltaMonitor(this.delta, propagator);
    }

    @Override
    public final void _setNot(BoolVar neg) {
        this.not = neg;
    }

    @Override
    public final BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public final boolean hasNot() {
        return this.not != null;
    }

    @Override
    public final boolean isLit() {
        return true;
    }

    @Override
    public final boolean isNot() {
        return this.isNot;
    }

    @Override
    public final void setNot(boolean isNot) {
        this.isNot = isNot;
    }
}

