/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDK;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.IntArrayCountFingerprint;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class ExtendedFingerprinter
implements IFingerprinter {
    private final int RESERVED_BITS = 25;
    private final Fingerprinter fingerprinter;

    public ExtendedFingerprinter() {
        this(1024, 7);
    }

    public ExtendedFingerprinter(int size) {
        this(size, 7);
    }

    public ExtendedFingerprinter(int size, int searchDepth) {
        this.fingerprinter = new Fingerprinter(size - 25, searchDepth);
    }

    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        return this.getBitFingerprint(container, null, null);
    }

    public Map<String, Integer> getRawFingerprint(IAtomContainer container) throws CDKException {
        Map fp = this.fingerprinter.getRawFingerprint(container);
        double weight = AtomContainerManipulator.getMass((IAtomContainer)container);
        for (int i = 1; i < 11; ++i) {
            if (!(weight > (double)(100 * i))) continue;
            fp.put("MASS_RANGE:" + i, 1);
        }
        IRingSet ringSet = Cycles.sssr((IAtomContainer)container).toRingSet();
        List rslist = RingPartitioner.partitionRings((IRingSet)ringSet);
        for (int i = 0; i < 7; ++i) {
            if (ringSet.getAtomContainerCount() <= i) continue;
            fp.compute("RNCT:" + (i + 1), (k, v) -> v != null ? v + 1 : 1);
        }
        int maxrcnt = 0;
        for (IRingSet rs : rslist) {
            if (rs.getAtomContainerCount() <= maxrcnt) continue;
            maxrcnt = rs.getAtomContainerCount();
        }
        for (int i = 0; i < maxrcnt && i < 9; ++i) {
            fp.put("RCNT_MAX:" + (i + 1), 1);
        }
        return fp;
    }

    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer, IRingSet ringSet, List<IRingSet> rslist) throws CDKException {
        int i;
        IAtomContainer container;
        try {
            container = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone input");
        }
        IBitFingerprint fingerprint = this.fingerprinter.getBitFingerprint(container);
        int size = this.getSize();
        double weight = MolecularFormulaManipulator.getTotalNaturalAbundance((IMolecularFormula)MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)container));
        for (i = 1; i < 11; ++i) {
            if (!(weight > (double)(100 * i))) continue;
            fingerprint.set(size - 26 + i);
        }
        if (ringSet == null) {
            ringSet = Cycles.sssr((IAtomContainer)container).toRingSet();
            rslist = RingPartitioner.partitionRings((IRingSet)ringSet);
        }
        for (i = 0; i < 7; ++i) {
            if (ringSet.getAtomContainerCount() <= i) continue;
            fingerprint.set(size - 15 + i);
        }
        int maxrcnt = 0;
        for (IRingSet iRingSet : rslist) {
            if (iRingSet.getAtomContainerCount() <= maxrcnt) continue;
            maxrcnt = iRingSet.getAtomContainerCount();
        }
        for (int i2 = 0; i2 < maxrcnt && i2 < 9; ++i2) {
            fingerprint.set(size - 8 + i2 - 3);
        }
        return fingerprint;
    }

    public int getSize() {
        return this.fingerprinter.getSize() + 25;
    }

    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        return new IntArrayCountFingerprint(this.getRawFingerprint(container));
    }

    public String getVersionDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("CDK-").append(this.getClass().getSimpleName()).append("/").append(CDK.getVersion());
        for (Map.Entry param : this.fingerprinter.getParameters()) {
            sb.append(' ').append((String)param.getKey()).append('=').append((String)param.getValue());
        }
        return sb.toString();
    }

    public BitSet getFingerprint(IAtomContainer mol) throws CDKException {
        return this.getBitFingerprint(mol).asBitSet();
    }

    public void setPathLimit(int pathLimit) {
        this.fingerprinter.setPathLimit(pathLimit);
    }

    public void setHashPseudoAtoms(boolean hashPseudoAtoms) {
        this.fingerprinter.setHashPseudoAtoms(hashPseudoAtoms);
    }
}

