library(neo4r)
con <- neo4j_api$new(
  url = "http://localhost:7474",
  user = "neo4j",
  password = "neo4j"
)

call_neo4j("CREATE CONSTRAINT ON (al:Band) ASSERT al.name IS UNIQUE;", con)
call_neo4j("CREATE CONSTRAINT ON (al:City) ASSERT al.name IS UNIQUE;", con)
call_neo4j("CREATE CONSTRAINT ON (al:record) ASSERT al.name IS UNIQUE;", con)
call_neo4j("CREATE CONSTRAINT ON (al:artist) ASSERT al.name IS UNIQUE;", con)

call_neo4j("MERGE (ancient:Band {name: 'Ancient', formed: 1992})
MERGE (acturus:Band {name: 'Arcturus', formed: 1991})
MERGE (burzum:Band {name: 'Burzum', formed: 1991})
MERGE (carpathianforest:Band {name: 'Carpathian Forest', formed: 1990})
MERGE (darkthrone:Band {name: 'Darkthrone', formed: 1986})
MERGE (emperor:Band {name: 'Emperor', formed: 1986})
MERGE (enslaved:Band {name: 'Enslaved', formed: 1991})
MERGE (gorgoroth:Band {name: 'Gorgoroth', formed: 1992})
MERGE (hades:Band {name: 'Hades', formed: 1992})
MERGE (immortal:Band {name: 'Immortal', formed: 1991})
MERGE (mayhem:Band {name: 'Mayhem', formed: 1984})
MERGE (satyricon:Band {name: 'Satyricon', formed: 1984})
MERGE (taake:Band {name: 'Taake', formed: 1993})
MERGE (bergen:City {name: 'Bergen'})
MERGE (oslo:City {name: 'Oslo'})
MERGE (sandnes:City {name: 'Sandnes'})
MERGE (rogaland:City {name: 'Rogaland'})
MERGE (deathcrush:record {name: 'Deathcrush', release: 1987})
MERGE (freezingmoon:record {name: 'Freezing Moon', release: 1987})
MERGE (carnage:record {name: 'Carnage', release: 1990})
MERGE (liveinleipzig:record {name: 'Live in Leipzig', release: 1990})
MERGE (demoi:record {name: 'Demo I', release: 1991})
MERGE (ablaze:record {name: 'A Blaze in the Northern Sky', release: 1991})
MERGE (immortal_rec:record {name: 'Immortal', release: 1991})
MERGE (demoii:record {name: 'Demo I', release: 1991})
MERGE (nema:record {name: 'Nema', release: 1991})
MERGE (burzum_rec:record {name: 'Burzum', release: 1992})
MERGE (detsom:record {name: 'Det som engang var', release: 1992})
MERGE (diabolical:record {name: 'Diabolical Fullmoon Mysticism', release: 1992})
MERGE (wrath:record {name: 'Wrath of the Tyrant', release: 1992})
MERGE (all_evil:record {name: 'All Evil', release: 1992})
MERGE (yggdrasill:record {name: 'Yggdrasill', release: 1992})
MERGE (funeral_moon:record {name: 'Under a Funeral Moon', release: 1992})
MERGE (aske:record {name: 'Aske', release: 1992})
MERGE (bloodlust:record {name: 'Bloodlust & Perversion', release: 1992})
MERGE (hvis:record {name: 'Hvis lyset tar oss', release: 1992})
MERGE (demys:record {name: 'De Mysteriis Dom Sathanas', release: 1992})
MERGE (hordanes:record {name: 'Hordanes Land', release: 1992})
MERGE (emperor_rec:record {name: 'Emperor', release: 1992})
MERGE (as_the_shadow:record {name: 'As the Shadows Rise', release: 1992})
MERGE (filosofem:record {name: 'Filosofem', release: 1993})
MERGE (theforest:record {name: 'The Forest Is My Throne', release: 1993})
MERGE (viking:record {name: 'Vikingligr Veldi', release: 1993})
MERGE (journey:record {name: 'Journey Through the Cold', release: 1993})
MERGE (moors:record {name: 'Moors of Svarttjern', release: 1993})
MERGE (asorcery:record {name: 'A Sorcery Written in Blood', release: 1993})
MERGE (inthenightside:record {name: 'In the Nightside Eclipse', release: 1993})
MERGE (darkmed:record {name: 'Dark Medieval Times', release: 1993})
MERGE (pureho:record {name: 'Pure Holocaust', release: 1993})
MERGE (trans:record {name: 'Transilvanian Hunger', release: 1993})
MERGE (euronymous:artist {name: 'Euronymous', born: 1968})
MERGE (vikernes:artist {name: 'Vikernes', born: 1973})
MERGE (fenriz:artist {name: 'Fenriz', born: 1971})
MERGE (gaahl:artist {name: 'Gaahl', born: 1975})
MERGE (euronymous)-[:PLAYED_IN]->(mayhem)
MERGE (vikernes)-[:PLAYED_IN]->(burzum)
MERGE (fenriz)-[:PLAYED_IN]->(Darkthrone)
MERGE (gaahl)-[:PLAYED_IN]->(gorgoroth)
MERGE (ancient)-[:IS_FROM]->(bergen)
MERGE (acturus)-[:IS_FROM]->(oslo)
MERGE (burzum)-[:IS_FROM]->(bergen)
MERGE (carpathianforest)-[:IS_FROM]->(rogaland)
MERGE (emperor)-[:IS_FROM]->(sandnes)
MERGE (enslaved)-[:IS_FROM]->(rogaland)
MERGE (gorgoroth)-[:IS_FROM]->(bergen)
MERGE (hades)-[:IS_FROM]->(bergen)
MERGE (immortal)-[:IS_FROM]->(bergen)
MERGE (mayhem)-[:IS_FROM]->(oslo)
MERGE (satyricon)-[:IS_FROM]->(oslo)
MERGE (taake)-[:IS_FROM]->(bergen)
MERGE (deathcrush)-[:WAS_RECORDED]->(mayhem)
MERGE (freezingmoon)-[:WAS_RECORDED]->(mayhem)
MERGE (carnage)-[:WAS_RECORDED]->(mayhem)
MERGE (liveinleipzig)-[:WAS_RECORDED]->(mayhem)
MERGE (demys)-[:WAS_RECORDED]->(mayhem)
MERGE (demoi)-[:WAS_RECORDED]->(burzum)
MERGE (demoii)-[:WAS_RECORDED]->(burzum)
MERGE (burzum_rec)-[:WAS_RECORDED]->(burzum)
MERGE (detsom)-[:WAS_RECORDED]->(burzum)
MERGE (aske)-[:WAS_RECORDED]->(burzum)
MERGE (hvis)-[:WAS_RECORDED]->(burzum)
MERGE (filosofem)-[:WAS_RECORDED]->(burzum)
MERGE (ablaze)-[:WAS_RECORDED]->(darkthrone)
MERGE (funeral_moon)-[:WAS_RECORDED]->(darkthrone)
MERGE (trans)-[:WAS_RECORDED]->(darkthrone)
MERGE (immortal_rec)-[:WAS_RECORDED]->(immortal)
MERGE (diabolical)-[:WAS_RECORDED]->(immortal)
MERGE (pureho)-[:WAS_RECORDED]->(immortal)
MERGE (nema)-[:WAS_RECORDED]->(enslaved)
MERGE (yggdrasill)-[:WAS_RECORDED]->(enslaved)
MERGE (hordanes)-[:WAS_RECORDED]->(enslaved)
MERGE (viking)-[:WAS_RECORDED]->(enslaved)
MERGE (wrath)-[:WAS_RECORDED]->(emperor)
MERGE (all_evil)-[:WAS_RECORDED]->(satyricon)
MERGE (theforest)-[:WAS_RECORDED]->(satyricon)
MERGE (darkmed)-[:WAS_RECORDED]->(satyricon)
MERGE (bloodlust)-[:WAS_RECORDED]->(carpathianforest)
MERGE (journey)-[:WAS_RECORDED]->(carpathianforest)
MERGE (moors)-[:WAS_RECORDED]->(carpathianforest)
MERGE (emperor_rec)-[:WAS_RECORDED]->(emperor)
MERGE (as_the_shadow)-[:WAS_RECORDED]->(emperor)
MERGE (inthenightside)-[:WAS_RECORDED]->(emperor)
MERGE (asorcery)-[:WAS_RECORDED]->(gorgoroth)", con)
