/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ParetoDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public ParetoDist(double alpha) {
        this.setParams(alpha, 1.0);
    }

    public ParetoDist(double alpha, double beta) {
        this.setParams(alpha, beta);
    }

    public double density(double x) {
        return ParetoDist.density(this.alpha, this.beta, x);
    }

    public double cdf(double x) {
        return ParetoDist.cdf(this.alpha, this.beta, x);
    }

    public double barF(double x) {
        return ParetoDist.barF(this.alpha, this.beta, x);
    }

    public double inverseF(double u) {
        return ParetoDist.inverseF(this.alpha, this.beta, u);
    }

    public double getMean() {
        return ParetoDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return ParetoDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return ParetoDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return x < beta ? 0.0 : alpha * Math.pow(beta / x, alpha) / x;
    }

    public static double cdf(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= beta) {
            return 0.0;
        }
        return 1.0 - Math.pow(beta / x, alpha);
    }

    public static double barF(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= beta) {
            return 1.0;
        }
        return Math.pow(beta / x, alpha);
    }

    public static double inverseF(double alpha, double beta, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return beta;
        }
        double t = -Math.log1p(-u);
        if (u >= 1.0 || t / Math.log(10.0) >= alpha * 308.0) {
            return Double.POSITIVE_INFINITY;
        }
        return beta / Math.pow(1.0 - u, 1.0 / alpha);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[2];
        parameters[1] = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (!(x[i] < parameters[1])) continue;
            parameters[1] = x[i];
        }
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            if (x[i] > 0.0) {
                sum += Math.log(x[i] / parameters[1]);
                continue;
            }
            sum -= 709.0;
        }
        parameters[0] = (double)n / sum;
        return parameters;
    }

    public static ParetoDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = ParetoDist.getMLE(x, n);
        return new ParetoDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        if (alpha <= 1.0) {
            throw new IllegalArgumentException("alpha <= 1");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return alpha * beta / (alpha - 1.0);
    }

    public static double getVariance(double alpha, double beta) {
        if (alpha <= 2.0) {
            throw new IllegalArgumentException("alpha <= 2");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return alpha * beta * beta / ((alpha - 2.0) * (alpha - 1.0) * (alpha - 1.0));
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Math.sqrt(ParetoDist.getVariance(alpha, beta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.supportA = beta;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }
}

