/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uno.informatics.data.DataType;
import uno.informatics.data.DataTypeConstants;
import uno.informatics.data.Feature;
import uno.informatics.data.Scale;
import uno.informatics.data.ScaleType;
import uno.informatics.data.dataset.DatasetException;
import uno.informatics.data.feature.ColumnFeature;
import uno.informatics.data.feature.ColumnFeaturePojo;
import uno.informatics.data.pojo.FeaturePojo;
import uno.informatics.data.pojo.SimpleFeaturePojo;

public class DatasetUtils {
    public static ColumnFeature createDefaultColumnFeature(String id, String name, int possibleDataTypes) {
        return new ColumnFeaturePojo(id, name, possibleDataTypes);
    }

    public static Feature createDefaultFeature(String id, String name, DataType dataType, ScaleType scaleType) {
        return new SimpleFeaturePojo(id, name, dataType, scaleType);
    }

    public static List<Feature> createFeatures(List<ColumnFeature> columnFeatures) {
        Iterator<ColumnFeature> iterator = columnFeatures.iterator();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (iterator.hasNext()) {
            features.add(DatasetUtils.createFeature(iterator.next()));
        }
        return features;
    }

    public static Feature createFeature(ColumnFeature columnFeature) {
        return new FeaturePojo(columnFeature);
    }

    public static final int getConversionType(Feature scale) {
        return scale != null ? DataTypeConstants.getConversionType(scale.getMethod().getScale().getDataType()) : 512;
    }

    public static final int getConversionType(Scale scale) {
        return scale != null ? DataTypeConstants.getConversionType(scale.getDataType()) : 512;
    }

    public static final int getConversionTypes(DataType ... dataTypes) {
        int conversionType = 0;
        for (int i = 0; i < dataTypes.length; ++i) {
            conversionType |= DataTypeConstants.getConversionType(dataTypes[i]);
        }
        return conversionType;
    }

    public static final int[] getConversionTypes(List<? extends Feature> features) {
        int[] types = new int[features.size()];
        Iterator<? extends Feature> iterator = features.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            types[i] = DataTypeConstants.getConversionType(iterator.next().getMethod().getScale().getDataType());
            ++i;
        }
        return types;
    }

    public static final int[] getConversionTypes(Feature rowHeaderFeature, List<? extends Feature> features) {
        int[] types = new int[features.size() + 1];
        types[0] = DataTypeConstants.getConversionType(rowHeaderFeature.getMethod().getScale().getDataType());
        Iterator<? extends Feature> iterator = features.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            types[i] = DataTypeConstants.getConversionType(iterator.next().getMethod().getScale().getDataType());
            ++i;
        }
        return types;
    }

    public static final List<DataType> getDataTypes(int conversionTypes) {
        DataType[] dataTypes = DataType.getAllTypes();
        LinkedList<DataType> list = new LinkedList<DataType>();
        for (int i = 0; i < dataTypes.length; ++i) {
            if ((DataTypeConstants.getConversionType(dataTypes[i]) & conversionTypes) <= 0) continue;
            list.add(dataTypes[i]);
        }
        return list;
    }

    public static final List<ScaleType> getScaleTypes(DataType dataType) {
        LinkedList<ScaleType> list = new LinkedList<ScaleType>();
        switch (dataType) {
            case BOOLEAN: {
                list.add(ScaleType.NOMINAL);
                break;
            }
            case DATE: {
                list.add(ScaleType.NOMINAL);
                break;
            }
            case DOUBLE: 
            case BIG_DECIMAL: 
            case FLOAT: {
                list.add(ScaleType.RATIO);
                list.add(ScaleType.INTERVAL);
                list.add(ScaleType.ORDINAL);
                list.add(ScaleType.NOMINAL);
                break;
            }
            case INTEGER: 
            case LONG: 
            case SHORT: 
            case BIG_INTEGER: {
                list.add(ScaleType.INTERVAL);
                list.add(ScaleType.ORDINAL);
                list.add(ScaleType.NOMINAL);
                break;
            }
            default: {
                list.add(ScaleType.NOMINAL);
            }
        }
        return list;
    }

    public static final Feature copyFeature(Feature feature) throws DatasetException {
        FeaturePojo newFeature = new FeaturePojo(feature);
        return newFeature;
    }
}

