/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.data.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moa.recommender.rc.data.AbstractRecommenderData;
import moa.recommender.rc.utils.Rating;
import moa.recommender.rc.utils.SparseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemRecommenderData
extends AbstractRecommenderData {
    private static final long serialVersionUID = 2844235954903772074L;
    protected Map<Integer, Map<Integer, Double>> ratingsUser;
    protected Map<Integer, Map<Integer, Double>> ratingsItem = new HashMap<Integer, Map<Integer, Double>>();
    protected Map<Integer, EntityStats> usersStats;
    protected Map<Integer, EntityStats> itemsStats;
    protected int nItems = 0;
    protected int nUsers = 0;
    protected double sumRatings = 0.0;
    protected int nRatings = 0;
    protected double minRating = 0.0;
    protected double maxRating = 0.0;

    public MemRecommenderData() {
        this.ratingsUser = new HashMap<Integer, Map<Integer, Double>>();
        this.usersStats = new HashMap<Integer, EntityStats>();
        this.itemsStats = new HashMap<Integer, EntityStats>();
    }

    @Override
    public void addUser(int userID, List<Integer> ratedItems, List<Double> ratings) {
        super.addUser(userID, ratedItems, ratings);
        this.ratingsUser.put(userID, new HashMap());
        this.usersStats.put(userID, new EntityStats());
        int n = ratedItems.size();
        for (int i = 0; i < n; ++i) {
            this.auxSetRating(userID, ratedItems.get(i), ratings.get(i));
        }
    }

    @Override
    public void removeUser(int userID) {
        super.removeUser(userID);
        this.ratingsUser.remove(userID);
        this.usersStats.remove(userID);
    }

    @Override
    public void addItem(int itemID, List<Integer> ratingUsers, List<Double> ratings) {
        super.addItem(itemID, ratingUsers, ratings);
        this.ratingsItem.put(itemID, new HashMap());
        this.itemsStats.put(itemID, new EntityStats());
        int n = ratingUsers.size();
        for (int i = 0; i < n; ++i) {
            this.auxSetRating(ratingUsers.get(i), itemID, ratings.get(i));
        }
    }

    @Override
    public void removeItem(int itemID) {
        super.removeItem(itemID);
        this.ratingsItem.remove(itemID);
        this.itemsStats.remove(itemID);
    }

    private void auxSetRating(int userID, int itemID, double rating) {
        if (this.nRatings == 0) {
            this.minRating = rating;
            this.maxRating = rating;
        } else {
            this.minRating = Math.min(this.minRating, rating);
            this.maxRating = Math.max(this.maxRating, rating);
        }
        EntityStats userStats = this.usersStats.get(userID);
        EntityStats itemStats = this.itemsStats.get(itemID);
        if (userStats == null) {
            ++this.nUsers;
            this.ratingsUser.put(userID, new HashMap());
            userStats = new EntityStats();
            this.usersStats.put(userID, userStats);
        }
        if (itemStats == null) {
            ++this.nItems;
            this.ratingsItem.put(itemID, new HashMap());
            itemStats = new EntityStats();
            this.itemsStats.put(itemID, itemStats);
        }
        Map<Integer, Double> ratUser = this.ratingsUser.get(userID);
        Map<Integer, Double> ratItem = this.ratingsItem.get(itemID);
        Double rat = ratUser.get(itemID);
        if (rat != null) {
            this.sumRatings -= rat.doubleValue();
            userStats.sum -= rat.doubleValue();
            userStats.num -= 1.0;
            itemStats.sum -= rat.doubleValue();
            itemStats.num -= 1.0;
            --this.nRatings;
        }
        userStats.sum += rating;
        userStats.num += 1.0;
        itemStats.sum += rating;
        itemStats.num += 1.0;
        this.sumRatings += rating;
        ++this.nRatings;
        ratUser.put(itemID, rating);
        ratItem.put(userID, rating);
    }

    @Override
    public void setRating(int userID, int itemID, double rating) {
        super.setRating(userID, itemID, rating);
        this.auxSetRating(userID, itemID, rating);
    }

    @Override
    public void removeRating(int userID, int itemID) {
        super.removeRating(userID, itemID);
        Map<Integer, Double> ratUser = this.ratingsUser.get(userID);
        Map<Integer, Double> ratItem = this.ratingsItem.get(itemID);
        Double rat = ratUser.get(itemID);
        EntityStats userStats = this.usersStats.get(userID);
        EntityStats itemStats = this.itemsStats.get(itemID);
        if (rat != null) {
            this.sumRatings -= rat.doubleValue();
            --this.nRatings;
            userStats.sum -= rat.doubleValue();
            userStats.num -= 1.0;
            itemStats.sum -= rat.doubleValue();
            itemStats.num -= 1.0;
            ratUser.remove(itemID);
            ratItem.remove(userID);
        }
    }

    @Override
    public SparseVector getRatingsUser(int userID) {
        Map<Integer, Double> ratUser = this.ratingsUser.get(userID);
        return new SparseVector(ratUser);
    }

    @Override
    public double getRating(int userID, int itemID) {
        Map<Integer, Double> ratUser = this.ratingsUser.get(userID);
        return ratUser.get(itemID) != null ? ratUser.get(itemID) : 0.0;
    }

    @Override
    public int getNumItems() {
        return this.nItems;
    }

    @Override
    public int getNumUsers() {
        return this.nUsers;
    }

    @Override
    public double getAvgRatingUser(int userID) {
        EntityStats stats = this.usersStats.get(userID);
        double sum = stats != null ? stats.sum : 0.0;
        double num = stats != null ? stats.num : 0.0;
        double mean = this.nRatings > 0 ? this.sumRatings / (double)this.nRatings : (this.minRating + this.maxRating) / 2.0;
        return (mean * 25.0 + sum) / (25.0 + num);
    }

    @Override
    public double getAvgRatingItem(int itemID) {
        EntityStats stats = this.itemsStats.get(itemID);
        double sum = stats != null ? stats.sum : 0.0;
        double num = stats != null ? stats.num : 0.0;
        double mean = this.nRatings > 0 ? this.sumRatings / (double)this.nRatings : (this.minRating + this.maxRating) / 2.0;
        return (mean * 25.0 + sum) / (25.0 + num);
    }

    @Override
    public double getMinRating() {
        return this.minRating;
    }

    @Override
    public double getMaxRating() {
        return this.maxRating;
    }

    @Override
    public Set<Integer> getUsers() {
        return this.usersStats.keySet();
    }

    @Override
    public SparseVector getRatingsItem(int itemID) {
        Map<Integer, Double> ratItem = this.ratingsItem.get(itemID);
        return new SparseVector(ratItem);
    }

    @Override
    public Set<Integer> getItems() {
        return this.itemsStats.keySet();
    }

    @Override
    public double getGlobalMean() {
        return this.nRatings > 0 ? this.sumRatings / (double)this.nRatings : (this.minRating + this.maxRating) / 2.0;
    }

    @Override
    public int countRatingsUser(int userID) {
        EntityStats stats = this.usersStats.get(userID);
        return stats != null ? (int)stats.num : 0;
    }

    @Override
    public int countRatingsItem(int itemID) {
        EntityStats stats = this.itemsStats.get(itemID);
        return stats != null ? (int)stats.num : 0;
    }

    @Override
    public Iterator<Rating> ratingIterator() {
        return null;
    }

    @Override
    public int getNumRatings() {
        return this.nRatings;
    }

    @Override
    public boolean userExists(int userID) {
        return this.usersStats.containsKey(userID);
    }

    @Override
    public boolean itemExists(int itemID) {
        return this.itemsStats.containsKey(itemID);
    }

    @Override
    public void clear() {
        this.usersStats.clear();
        this.itemsStats.clear();
        this.nUsers = 0;
        this.nItems = 0;
        this.minRating = this.maxRating = (double)0;
        this.nRatings = 0;
        this.sumRatings = 0;
        this.ratingsUser.clear();
        this.ratingsItem.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RatingIterator
    implements Iterator<Rating> {
        private int currentUser = -1;
        private Iterator<Integer> userIt = null;
        private Iterator<Map.Entry<Integer, Double>> ratsIt = null;
        private boolean calculated = false;
        private boolean result = true;

        RatingIterator() throws Exception {
        }

        @Override
        public boolean hasNext() {
            if (this.calculated) {
                return this.result;
            }
            this.calculated = true;
            this.result = false;
            if (this.ratsIt == null) {
                if (!MemRecommenderData.this.ratingsUser.isEmpty()) {
                    this.userIt = MemRecommenderData.this.ratingsUser.keySet().iterator();
                    if (this.userIt.hasNext()) {
                        Integer first = this.userIt.next();
                        this.currentUser = first;
                        this.ratsIt = MemRecommenderData.this.ratingsUser.get(first).entrySet().iterator();
                        if (this.ratsIt.hasNext()) {
                            this.result = true;
                        }
                    }
                }
            } else if (this.ratsIt.hasNext()) {
                this.result = true;
            } else if (this.userIt.hasNext()) {
                Integer first = this.userIt.next();
                this.currentUser = first;
                this.ratsIt = MemRecommenderData.this.ratingsUser.get(first).entrySet().iterator();
                if (this.ratsIt.hasNext()) {
                    this.result = true;
                }
            }
            return this.result;
        }

        @Override
        public Rating next() {
            if (!this.calculated) {
                this.hasNext();
            }
            this.calculated = false;
            Map.Entry<Integer, Double> pair = this.ratsIt.next();
            return new Rating(this.currentUser, pair.getKey(), pair.getValue());
        }

        @Override
        public void remove() {
        }
    }

    class EntityStats
    implements Serializable {
        private static final long serialVersionUID = -8933750377510577120L;
        public double sum = 0.0;
        public double num = 0.0;

        EntityStats() {
        }
    }
}

