/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import umontreal.iro.lecuyer.stat.FunctionOfMultipleMeansTally;
import umontreal.iro.lecuyer.stat.list.ListOfStatProbes;
import umontreal.iro.lecuyer.util.MultivariateFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfFunctionOfMultipleMeansTallies<E extends FunctionOfMultipleMeansTally>
extends ListOfStatProbes<E> {
    double[][] temp = null;

    public ListOfFunctionOfMultipleMeansTallies() {
    }

    public ListOfFunctionOfMultipleMeansTallies(String string) {
        super(string);
    }

    public static ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> create(MultivariateFunction multivariateFunction, int n, int n2) {
        ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> listOfFunctionOfMultipleMeansTallies = new ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally>();
        for (int i = 0; i < n2; ++i) {
            listOfFunctionOfMultipleMeansTallies.add(new FunctionOfMultipleMeansTally(multivariateFunction, n));
        }
        return listOfFunctionOfMultipleMeansTallies;
    }

    public void add(double[][] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Invalid number of vectors of observations: the given length is " + dArray.length + ", but the required length is " + this.size());
        }
        if (this.collect) {
            for (int i = 0; i < this.size(); ++i) {
                FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i);
                if (functionOfMultipleMeansTally == null) continue;
                functionOfMultipleMeansTally.add(dArray[i]);
            }
        }
    }

    public void add(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.size()) {
            throw new IllegalArgumentException("Invalid number of vectors of observations: the given number is " + doubleMatrix2D.rows() + ", but the required number is " + this.size());
        }
        if (this.collect) {
            for (int i = 0; i < this.size(); ++i) {
                FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i);
                if (functionOfMultipleMeansTally == null) continue;
                functionOfMultipleMeansTally.add(doubleMatrix2D.viewRow(i).toArray());
            }
        }
    }

    public void addSameDimension(double[] ... dArray) {
        int n;
        int n2 = this.size();
        int n3 = this.getDimension();
        if (dArray.length != n3) {
            throw new IllegalArgumentException("The length of the given array must be " + n3 + " while its actual length is " + dArray.length);
        }
        if (dArray.length == 0 || n2 == 0) {
            return;
        }
        if (n2 != dArray[0].length) {
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        for (n = 0; n < dArray.length - 1; ++n) {
            if (dArray[n].length == dArray[n + 1].length) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != n2 || this.temp[0].length != n3) {
            this.temp = new double[n2][n3];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                this.temp[n][i] = dArray[i][n];
            }
        }
        this.add(this.temp);
    }

    public void addSameDimension(DoubleMatrix1D ... doubleMatrix1DArray) {
        int n;
        int n2 = this.size();
        int n3 = this.getDimension();
        if (doubleMatrix1DArray.length != n3) {
            throw new IllegalArgumentException("The length of the given array must be " + n3 + " while its actual length is " + doubleMatrix1DArray.length);
        }
        if (doubleMatrix1DArray.length == 0 || n2 == 0) {
            return;
        }
        if (n2 != doubleMatrix1DArray[0].size()) {
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        for (n = 0; n < doubleMatrix1DArray.length - 1; ++n) {
            if (doubleMatrix1DArray[n].size() == doubleMatrix1DArray[n + 1].size()) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != n2 || this.temp[0].length != n3) {
            this.temp = new double[n2][n3];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                this.temp[n][i] = doubleMatrix1DArray[i].get(n);
            }
        }
        this.add(this.temp);
    }

    public int getDimension() {
        if (this.size() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(0);
        return functionOfMultipleMeansTally == null ? 0 : functionOfMultipleMeansTally.getDimension();
    }

    public int numberObs() {
        if (this.size() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(0);
        return functionOfMultipleMeansTally == null ? 0 : functionOfMultipleMeansTally.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int n = this.size();
        int n2 = this.numberObs();
        for (int i = 1; i < n; ++i) {
            FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i);
            if (functionOfMultipleMeansTally.numberObs() == n2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void average(double[] dArray) {
        super.average(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || ((FunctionOfMultipleMeansTally)this.get(i)).numberObs() != 0) continue;
            dArray[i] = Double.NaN;
        }
    }

    public void variance(double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Incompatible array length: the given length is " + dArray.length + " while the required length is " + this.size());
        }
        for (int i = 0; i < dArray.length; ++i) {
            FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i);
            dArray[i] = functionOfMultipleMeansTally == null || functionOfMultipleMeansTally.numberObs() < 2 ? Double.NaN : functionOfMultipleMeansTally.variance();
        }
    }

    public void standardDeviation(double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Incompatible array length: the given length is " + dArray.length + " while the required length is " + this.size());
        }
        for (int i = 0; i < dArray.length; ++i) {
            FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i);
            dArray[i] = functionOfMultipleMeansTally == null || functionOfMultipleMeansTally.numberObs() < 2 ? Double.NaN : functionOfMultipleMeansTally.standardDeviation();
        }
    }

    @Override
    public ListOfFunctionOfMultipleMeansTallies<E> clone() {
        ListOfFunctionOfMultipleMeansTallies listOfFunctionOfMultipleMeansTallies = (ListOfFunctionOfMultipleMeansTallies)super.clone();
        if (this.temp != null) {
            listOfFunctionOfMultipleMeansTallies.temp = new double[this.temp.length][this.temp[0].length];
            for (int i = 0; i < this.temp.length; ++i) {
                int n = 0;
                while (n < this.temp[i].length) {
                    listOfFunctionOfMultipleMeansTallies.temp[i][n] = this.temp[i][n];
                    ++i;
                }
            }
        }
        return listOfFunctionOfMultipleMeansTallies;
    }
}

