/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDComplexMatrix3D
extends WrapperDComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    private double[][][] elements;
    private DoubleFFT_3D fft3;
    private DoubleFFT_2D fft2Slices;

    public DenseLargeDComplexMatrix3D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new double[n][n2][2 * n3];
    }

    public double[] getQuick(int n, int n2, int n3) {
        return new double[]{this.elements[n][n2][2 * n3], this.elements[n][n2][2 * n3 + 1]};
    }

    public void setQuick(int n, int n2, int n3, double[] dArray) {
        this.elements[n][n2][2 * n3] = dArray[0];
        this.elements[n][n2][2 * n3 + 1] = dArray[1];
    }

    public void setQuick(int n, int n2, int n3, double d, double d2) {
        this.elements[n][n2][2 * n3] = d;
        this.elements[n][n2][2 * n3 + 1] = d2;
    }

    public void fft2Slices() {
        int n;
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDComplexMatrix3D.this.fft2Slices.complexForward(DenseLargeDComplexMatrix3D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.fft2Slices.complexForward(this.elements[i]);
            }
        }
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft2Slices(final boolean bl) {
        int n;
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDComplexMatrix3D.this.fft2Slices.complexInverse(DenseLargeDComplexMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.fft2Slices.complexInverse(this.elements[i], bl);
            }
        }
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[][][] elements() {
        return this.elements;
    }

    protected DComplexMatrix3D getContent() {
        return this;
    }

    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseLargeDComplexMatrix3D(n, n2, n3);
    }
}

