/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.inference.markovjumps.MarkovReward;
import dr.math.Binomial;
import dr.math.GammaFunction;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.GeneralizedIntegerGammaDistribution;
import dr.math.matrixAlgebra.Vector;

public class TwoStateOccupancyMarkovReward
implements MarkovReward {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG2 = false;
    private double[] jumpProbabilities = null;
    private EigenDecomposition eigenDecomposition;
    private final double[] Q;
    private final int maxK;
    private final double epsilon;
    private final EigenSystem eigenSystem;
    private double maxTime;
    private double[][] C = null;
    private double[][] D = null;

    public TwoStateOccupancyMarkovReward(double[] dArray) {
        this(dArray, 1.0E-10);
    }

    public TwoStateOccupancyMarkovReward(double[] dArray, double d) {
        this.Q = dArray;
        this.maxTime = 0.0;
        this.epsilon = d;
        this.maxK = 10;
        this.eigenSystem = new DefaultEigenSystem(2);
    }

    private int idx(int n, int n2) {
        return n * 2 + n2;
    }

    private void computeCDForJumpProbabilities(double d, double d2, double[][] dArray, double[][] dArray2) {
        if (d == d2) {
            return;
        }
        for (int i = 0; i < this.maxK / 2; ++i) {
            double d3 = Math.pow(d * d2, i);
            for (int j = 0; j <= i + 1; ++j) {
                double d4 = Math.pow(-1.0, j);
                dArray[i][j] = i == 0 && j == 0 ? 1.0 : d4 * d3 * Binomial.choose(i + j - 1, j) / Math.pow(d2 - d, i + j);
                dArray2[i][j] = d4 * d3 * Binomial.choose(i + j, j) / Math.pow(d - d2, i + j + 1);
            }
        }
    }

    private void computeJumpProbabilities(double d, double d2, double d3, double[][] dArray, double[][] dArray2, double[] dArray3) {
        double d4 = Math.exp(-d * d3);
        double d5 = Math.exp(-d2 * d3);
        if (d == d2) {
            for (int i = 1; i < this.maxK / 2 + 1; ++i) {
                int n = 2 * i;
                dArray3[n] = d4 * Math.pow(d * d3, n) / Math.exp(GammaFunction.lnGamma(n + 1));
            }
        } else {
            for (int i = 1; i < this.maxK / 2; ++i) {
                double d6 = 0.0;
                double d7 = 1.0;
                for (int j = 1; j <= i + 1; ++j) {
                    if (j > 1) {
                        d7 *= d3 / (double)(j - 1);
                    }
                    d6 += dArray[i][i - j + 1] * d7 * d4;
                    if (j > i) continue;
                    d6 += dArray2[i][i - j] * d7 * d5;
                }
                dArray3[2 * i] = d6;
            }
        }
    }

    public double[][] getC() {
        return this.C;
    }

    public double[][] getD() {
        return this.D;
    }

    public double[] getJumpProbabilities() {
        return this.jumpProbabilities;
    }

    @Override
    public double computeCdf(double d, double d2, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double computePdf(double d, double d2, int n, int n2) {
        double d3;
        boolean bl;
        if (n != 0 || n2 != 0) {
            throw new RuntimeException("Not yet implemented");
        }
        double d4 = -this.Q[this.idx(0, 0)];
        boolean bl2 = bl = d4 == (d3 = -this.Q[this.idx(1, 1)]);
        if (!bl && this.C == null) {
            this.C = new double[this.maxK / 2 + 1][this.maxK / 2 + 1];
            this.D = new double[this.maxK / 2 + 1][this.maxK / 2 + 1];
            this.computeCDForJumpProbabilities(d4, d3, this.C, this.D);
        }
        if (this.jumpProbabilities == null) {
            this.jumpProbabilities = new double[this.maxK + 1];
        }
        this.computeJumpProbabilities(d4, d3, d2, this.C, this.D, this.jumpProbabilities);
        if (bl) {
            double d5 = 1.0 / d4;
            double d6 = 0.0;
            for (int i = 1; i <= this.maxK / 2; ++i) {
                int n3 = 2 * i;
                d6 += this.jumpProbabilities[n3] * Math.exp(GammaDistribution.logPdf(d, i, d5) + GammaDistribution.logPdf(d2 - d, i + 1, d5) - GammaDistribution.logPdf(d2, n3 + 1, d5));
            }
            return d6;
        }
        double d7 = 0.0;
        for (int i = 1; i <= this.maxK / 2; ++i) {
            int n4 = 2 * i;
            d7 += this.jumpProbabilities[n4] * GammaDistribution.pdf(d, i, 1.0 / d3) * GammaDistribution.pdf(d2 - d, i + 1, 1.0 / d4) / GeneralizedIntegerGammaDistribution.pdf(d2, i, i + 1, d3, d4);
        }
        return d7;
    }

    @Override
    public double[] computePdf(double d, double d2) {
        throw new RuntimeException("Not yet implemented");
    }

    private double[][] squareMatrix(double[] dArray) {
        double[][] dArray2 = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                dArray2[i][j] = dArray[this.idx(i, j)];
            }
        }
        return dArray2;
    }

    private int determineNumberOfSteps(double d, double d2) {
        double d3;
        int n = -1;
        double d4 = 1.0 - this.epsilon;
        for (double d5 = 0.0; Math.abs(d5 - d4) > this.epsilon && d5 < 1.0; d5 += Math.exp(d3)) {
            d3 = -d2 * d + (double)(++n) * (Math.log(d2) + Math.log(d)) - GammaFunction.lnGamma(n + 1);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Q: " + new Vector(this.Q) + "\n");
        return stringBuilder.toString();
    }

    private EigenDecomposition getEigenDecomposition() {
        if (this.eigenDecomposition == null) {
            this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.squareMatrix(this.Q));
        }
        return this.eigenDecomposition;
    }

    public double[] computeConditionalProbabilities(double d) {
        double[] dArray = new double[4];
        this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, dArray);
        return dArray;
    }

    @Override
    public double computeConditionalProbability(double d, int n, int n2) {
        return this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, n, n2);
    }
}

